﻿var questionnaireEditor = {
    Id: 0,
    container: null,
    blockController: null,
    questionController: null,
    surveyOptions: null,
    sessionFrame: null,
    errorOnRequest: false,
    completedActionCallback: null,
    currentEditor: null,
    buttonClick: false,
    queueSyncCalls: null,
    previewTimer: null,
    blockLogicBannerTimer: null,
    expandBlockTimer: null,
    blockItemDragActive: false,
    isStructureViewMode: false,
    questionnaireMode: null,
    maxQuestionsCopy: 0,
    configuration: null,
    activeBlock: null,
    lastOpenQuestion: null,
    activeMaskBlock: null,

    batchInsert: false,
    batchInsertCode: 0,

    expandAllBlocks: null,
    actionsLoaded: false,
    requireIndexVerification: true,

    data: null,
    blocks: [],
    questionTypes: [],
    questions: [],
    variables: [],
    choices: [],
    actions: [],
    languages: [],
    timeZones: [],
    panels: null,
    panelAttributes: null,
    lookupTables: null,
    editComputeVariables: [],     // Used to have current variables before editing question logic (for cancel). Save will retrieve variables again.
    blockEditVariables: [],
    questionCategories: null,
    nbBlocks: 0,
    nbQuestions: 0,
    disabledDateControl: null,

    findQuestions: [],
    findPosition: null,
    findNewSearch: true,

    editValues: {},
    editTexts: {},
    editChoices: {},

    useS2: false
};

$(document).ready(function () {
    var pathName = window.location.pathname;
    questionnaireEditor.questionnaireMode = questionnaireEditor;
    questionnaireEditor.container = $("#questionnaireContainer");
    questionnaireEditor.surveyOptions = $("#surveyOptions", questionnaireEditor.container);
    questionnaireEditor.sessionFrame = $("#SessionKeepAliveFrame");
    questionnaireEditor.queueSyncCalls = [];
    a4.busyBoxTimeout = 3000;
    a4.busyBoxEnabled = true;

    questionnaireEditor.setQuestionnaireData();
    questionnaireEditor.setUIElements();
    questionnaireEditor.setQuestionnaireEvents();
    
    questionnaireEditor.blockController = new questionnaireEditorBlockController();
    questionnaireEditor.blockController.init(questionnaireEditor);

    questionnaireEditor.questionController = new questionnaireEditorQuestionController();
    questionnaireEditor.questionController.init(questionnaireEditor)

    
    questionnaireEditor.setAdvancedFindEvents();
    questionnaireEditor.blockController.initBlockDefaultPreview();

    if (libraryBrowser) {
        var pathName = window.location.pathname;
        libraryBrowser.initLibraryBrowser(questionnaireEditor.container, pathName.substring(0, pathName.indexOf('/Edit') + 1), questionnaireEditor.Id);
        libraryBrowser.setImportQuestionsEvents();
    }
});

// --------------- UI elements - Events functions ------------------------------------

questionnaireEditor.switchViewMode = function (switchMode) {
    var leftPanel = $(".v-leftPanel");
    var structureContainer = $(".v-structureBlockContainer");
    var optionsPanel = $(".v-structureDisplayOptions", leftPanel);
    var optionsPanelOptions = $(".v-structurOptions", optionsPanel);
    var optionsPanelHeader = $(".v-sectionHeader", optionsPanel);
    var editOnlyItems = $(".v-editOnly", leftPanel);
    var surveyOptionsPanel = $("#surveyOptions");
    var surveyOptionsPanelToolBar = $(".v-toolbar", surveyOptionsPanel);
    var toolBar = $("#surveyOptions .v-toolBarWrapper");
    var visibleQuestionId = null;
    var nmbLoadingBlocks = 0;

    if (switchMode == "edit") {
        questionnaireEditor.questionnaireMode = questionnaireEditor;

        var doAfterAllBlocksLoaded = function () {
            $("#structureQuestionnaireContainer").hide();

            if (nmbLoadingBlocks == 0) {

                structureContainer.hide();
                toolBar.show();

                if (optionsPanelOptions.is(":visible")) {
                    optionsPanelHeader.trigger("click");
                }

                optionsPanel.addClass("hidden");
                editOnlyItems.show();
                questionnaireEditor.isStructureViewMode = false;

                $(".v-editBlockContainer").show();
                structureContainer.empty();

                if (visibleQuestionId !== null) {
                    setTimeout(function () {
                        $('html, body').animate({
                            scrollTop: $("#blockItemPanel" + visibleQuestionId + ".v-blockItemPanel").offset().top
                        }, 500);
                    }, 20);
                }
            } else {
                setTimeout(doAfterAllBlocksLoaded, 1000);
            }
        }

        //open/close blocks/questions in edit mode
        $(".v-blockStructurePanel").each(function (i, e) {
            var id = $(this).attr("id");
            var structureBlockPanel = $(this);
            var structureQuestionsContainer = $(this).find(".v-questionsContainer");
            var structureBlockOpened = structureQuestionsContainer.length != 0 ? (structureQuestionsContainer.css("display") == "block") : false;

            var blockTriggerQuestions = function (afterBlockExpand) {
                $(".v-blockItemStructurePanel", structureBlockPanel).each(function (i, e) {
                    var itemId = $(this).attr("id").replace("blockItemPanel", "");
                    var structureItemOpened = $(this).find(".v-structureQuestionContent:not(.hidden)").length != 0;
                    var name = $(this).find(".h-questionTitle").html();

                    var editBlockItemPanel = $("#blockItemPanel" + itemId + ".v-blockItemPanel")
                    var editBlockItemOpened = editBlockItemPanel.length != 0 ? (editBlockItemPanel.find(".v-editQuestionContent:not(.hidden)").length != 0) : false;

                    if (editBlockItemPanel.length != 0 && (structureItemOpened != editBlockItemOpened)) {
                        questionnaireEditor.toggleQuestion(editBlockItemPanel.find(".h-expandQuestion"), false);
                    }

                    if (visibleQuestionId == null && structureBlockOpened) {
                        visibleQuestionId = questionnaireEditor.verifyIfQuestionIsInViewport(e) ? itemId : null;
                    }
                })
            }

            //block
            var editBlockPanel = $("#blockPanel" + id);
            var editQuestionsContainer = $(".v-questionsContainer", editBlockPanel);
            var editBlockOpened = editQuestionsContainer.length != 0 ? (editQuestionsContainer.css("display") == "block") : false;
            if (structureBlockOpened !== editBlockOpened) {
                nmbLoadingBlocks++;
                questionnaireEditor.questionnaireMode.toggleBlock(editBlockPanel.find(".h-expandBlock"), false, function () { nmbLoadingBlocks--; blockTriggerQuestions(); });
            } else {
                blockTriggerQuestions();
            }
        });

        doAfterAllBlocksLoaded();

    }
    else {
        var qSettings = $(".v-structureQuestionnaireContainer", questionnaireEditor.container);

        if (qSettings.attr("data-loaded") == "false") {
            questionnaireStructure.loadQuestionnaireSettingsContent();
        }
        else {
            $("#structureQuestionnaireContainer").show();
        }

        $(".v-blockPanel.expanded .v-blockItemPanel").each(function (i, e) {
            visibleQuestionId = questionnaireEditor.verifyIfQuestionIsInViewport(e) ? $(this).attr("id").replace("blockItemPanel", "") : null;
            if (visibleQuestionId != null) {
                return false;
            }
        });

        questionnaireEditor.questionnaireMode = questionnaireStructure;
        $(".v-editBlockContainer").hide();
        editOnlyItems.hide();
        structureContainer.show();
        toolBar.hide();
        optionsPanelHeader.trigger("click");
        optionsPanel.removeClass("hidden");
        questionnaireEditor.isStructureViewMode = true;
        questionnaireStructure.setUIElements(null, visibleQuestionId);
    }
}

// --------------- UI elements - SETUP functions ------------------------------------

questionnaireEditor.setUIElements = function () {
    var orderedTypes = $(".question-types-menu.ordered-types", questionnaireEditor.container);
    questionnaireEditor.setSelectorViewport(orderedTypes);
    questionnaireEditor.setSurveyOptionsPanel();
    orderedTypes.mCustomScrollbar({ theme: "dark-2", scrollInertia: 0 });

    if (canModify) {
        questionnaireEditor.setBlocksDraggable($(".h-newBlock", questionnaireEditor.container));
        questionnaireEditor.setBlocksDraggable($(".v-questionSelector ul.v-folderList .h-folder[data-section=MyLibrary]", questionnaireEditor.container));
        questionnaireEditor.setBlocksDraggable($(".v-questionSelector ul.v-folderList .h-folder[data-section=PublicLibrary]", questionnaireEditor.container));

        var onBlockSort = function (draggable, draggableContainer) {
            var previousBlock = draggableContainer.prev(".v-blockPanel");
            var previousBlockId = (previousBlock.length > 0) ? questionnaireEditor.blockController.getBlockIdFromElement(previousBlock) : null;
            var position = (previousBlockId == null) ? 0 : null;
            draggableContainer.hide();

            var dragBlockCompleteCallback = function (result) {
                draggableContainer.replaceWith(result);
                draggableContainer.show();
            };

            if (draggable.hasClass("h-newBlock")) {
                questionnaireEditor.blockController.createBlock(previousBlockId, position, dragBlockCompleteCallback);
            }
            else if (draggable.hasClass("h-folderItem")) {
                questionnaireEditor.blockController.copyBlock($(".h-folder", draggable).attr("data-id"), previousBlockId, position, dragBlockCompleteCallback);
            }
            else if (draggable.hasClass("h-folder")) {
                questionnaireEditor.importLibraryCategory(draggable.attr("data-id"), draggable.attr("data-section"), previousBlockId, position, dragBlockCompleteCallback);
            }
            else if (draggable.hasClass("v-blockPanel")) {
                if (draggable.index() != draggable.attr("data-index")) {
                    var nextBlockId = (draggableContainer.next(".v-blockPanel").length > 0)
                        ? questionnaireEditor.blockController.getBlockIdFromElement(draggableContainer.next(".v-blockPanel")) : null;

                    var blockId = questionnaireEditor.blockController.getBlockIdFromElement(draggableContainer);
                    questionnaireEditor.blockController.moveBlock(blockId, previousBlockId, nextBlockId, (draggable.index() < draggable.attr("data-index")));
                }

                draggableContainer.show();
            }
            else {
                draggableContainer.show();
            }
        }

        $("#blocksContainer", questionnaireEditor.container).sortable({
            forcePlaceholderSize: true,
            items: ".v-blockPanel",
            handle: ".v-moveBlock",
            placeholder: "block-sortable-placeholder",
            start: function (event, ui) {
                var draggable = $(ui.item);

                if (draggable.hasClass("v-blockPanel")) {
                    draggable.attr("data-index", draggable.index());
                }
            },
            stop: function (event, ui) {
                var item = $(ui.item);
                onBlockSort(item, item);
            },
            receive: function (event, ui) {
                var draggable = $(ui.item);
                var draggableContainer = $(ui.helper);
                onBlockSort(draggable, draggableContainer);
            }
        });

        questionnaireEditor.setBlockItemsDraggable($(".h-questionnaireItem", questionnaireEditor.container));
        questionnaireEditor.setBlockItemsSortable($(".v-blockPanel .v-questionsContainer", questionnaireEditor.container));
    }

    $(".h-newBlock, .h-questionnaireItem").disableSelection();

    $(".v-questionSelector .h-headerItem", questionnaireEditor.container).on("click", function (e) {
        var header = $(this).closest(".v-sectionHeader");
        var section = header.siblings(".v-sectionItems");
        var advancedSearch = header.closest(".v-advancedSearch");
        var structureOptions = header.closest(".v-structureDisplayOptions");
        var library = header.closest(".library");
        var topLevel = section.hasClass("v-folderList");
        var selector = section.closest(".v-questionSelector");

        if (structureOptions.length != 0) {
            e.stopPropagation();

            libraryBrowser.changeLibraryNavigation(library, true, true);
            section.toggle();
            toogleCaretIcon(selector, header, section);

            $(".v-structurOptions", structureOptions).toggle();
            $(".v-sectionItems:first", selector).hide();    // Tools
        }

        if (advancedSearch.length != 0) {
            e.stopPropagation();

            libraryBrowser.changeLibraryNavigation(library, true, true);
            section.toggle();
            toogleCaretIcon(selector, header, section);

            $(".v-search", advancedSearch).toggle();
            $(".v-sectionItems:first", selector).hide();    // Tools
        }
        else if (library.length == 0) {
            var openSection = $(".v-libraryBrowser .library .v-folderList:visible");

            if (openSection.length > 0) {
                libraryBrowser.changeLibraryNavigation(openSection.closest(".library"), false, true);
            }
            section.toggle();
            toogleCaretIcon(selector, header, section);
        }
        else {
            var subSectionsClosed = $(".v-subFolderList li:visible", section).length == 0;

            // For section items with folders we don't complete the folders click if list open and no items are visible (already top level)
            if (topLevel && $("li:visible", section).length > 0 && subSectionsClosed) {
                libraryBrowser.resetBrowser(library);
                e.stopPropagation();
            }
            else if (topLevel) {
                libraryBrowser.changeLibraryNavigation(library, true, true);
            }

            section.toggle();
            toogleCaretIcon(selector, header, section);

            $(".v-folderList:first", selector).hide();
            $(".v-sectionItems:first", selector).hide();    // Tools
        }
    });

    function toogleCaretIcon(selector, header, section) {
        $(".h-headerItem .fa-caret-right", selector).show();
        $(".h-headerItem .fa-caret-down", selector).hide();

        $(".fa-caret-right", header).toggle(!section.is(":visible"));
        $(".fa-caret-down", header).toggle(section.is(":visible"));
    }

    questionnaireEditor.container.on("click", ".v-bannerContainer .h-bannerHeader", function (e) {
        var container = $(this).closest(".v-bannerContainer");
        $(this).find(".fa").toggle();
        $(".v-bannerItems", container).toggle();
    });

    questionnaireEditor.container.on("change", "#EnableMobileRendering", function () {
        var useMobileRenderingForDesktopCheckbox = $(this).parent().find("#UseMobileRenderingForDesktop");
        if (useMobileRenderingForDesktopCheckbox) {
            if ($(this).is(":checked")) {
                useMobileRenderingForDesktopCheckbox.removeAttr("disabled");
            } else {
                useMobileRenderingForDesktopCheckbox.prop("checked", false);
                useMobileRenderingForDesktopCheckbox.attr("disabled", true);
            }
        }
    });

    questionnaireEditor.container.on("mouseenter", ".v-optionList", function () {
        $(this).find(".v-optionListItems").show();
    });

    questionnaireEditor.container.on("mouseleave", ".v-optionList", function () {
        $(this).find(".v-optionListItems, .v-questionTypesPanel").hide();
        $(document).off("click.hideQuestionTypesPanel");
    });

    questionnaireEditor.container.on("mouseenter", ".v-optionList .h-changeQuestionType", function () {
        questionnaireEditor.questionController.showQuestionTypesPanel($(this), null);
    });

    questionnaireEditor.container.on("mouseleave", ".v-optionList .h-changeQuestionType", function () {
        var questionTypesPanel = $(".v-questionTypesPanel", $(this));
        questionTypesPanel.hide();
    });

    questionnaireEditor.container.on("click", ".h-previewSurveyAtQuestion", function () {
        var item = $(this);
        a4.previewSurvey(questionnaireEditor.useS2, $("#HiddenSurveyToken").val() + "&sqid=" + item.attr("data-id"));
    });

    $(window).on("resize", function () {
        questionnaireEditor.setSelectorViewport($(".question-types-menu.ordered-types", questionnaireEditor.container));
        questionnaireEditor.setSurveyOptionsPanel();

        orderedTypes.mCustomScrollbar("destroy");
        orderedTypes.mCustomScrollbar({ theme: "dark-2", scrollInertia: 0 });
    });


    $(window).on("scroll", function (e) {
        var so = questionnaireEditor.surveyOptions;

        if ($(this).scrollTop() > (200) && so.css('position') != 'fixed') {
            var widthInPct = ($(".right-panel", questionnaireEditor.container).width() / $("#main").width()) * 100;

            so.css({ 'position': 'fixed', 'top': '0px', 'padding': '10px 0px 20px 5px', 'width': widthInPct + "%" });
            so.addClass("shadowed");
            $(".preview-button", so).css('margin-right', '2%');
            $("#blocksContainer", questionnaireEditor.container).css("margin-top", "50px");
        }
        else if ($(this).scrollTop() < (200) && so.css('position') != 'absolute') {
            so.css({ 'position': 'relative', 'padding': '0px 0px 0px 5px', 'width': '98%' });
            so.removeClass("shadowed");
            $(".preview-button", so).css('margin-right', '0%');
            $("#blocksContainer", questionnaireEditor.container).css("margin-top", "0px");
        }

        questionnaireEditor.ensurePreviewIsHidden();
    });
}

questionnaireEditor.setSurveyOptionsPanel = function () {
    if ($(window).width() <= 1300 && !questionnaireEditor.surveyOptions.hasClass("small")) {
        questionnaireEditor.surveyOptions.addClass("small");
        $("#blocksContainer", questionnaireEditor.container).addClass("small");
    }
    else if ($(window).width() > 1300 && questionnaireEditor.surveyOptions.hasClass("small")) {
        questionnaireEditor.surveyOptions.removeClass("small");
        $("#blocksContainer", questionnaireEditor.container).removeClass("small");
    }
}

questionnaireEditor.ensurePreviewIsHidden = function () {
    var preview = $("#previewQuestionContainer", questionnaireEditor.container);
    if (preview.is(":visible")) {
        preview.trigger("mouseleave");
    }
    else {
        window.clearTimeout(questionnaireEditor.previewTimer);
    }
}

questionnaireEditor.setSelectorViewport = function (orderedTypes) {
    if (!orderedTypes.hasClass("merged") && $(window).height() < 880) {
        var basicElements = $(".question-types-menu:not(.ordered-types)", questionnaireEditor.container);
        $(".h-questionnaireItem", basicElements).addClass("unset")

        if ($(".viewport .overview", orderedTypes).length == 0) {
            orderedTypes.prepend(basicElements.html());
        }
        else {
            $(".viewport .overview", orderedTypes).prepend(basicElements.html());
        }

        basicElements.next(".item-divider").remove();
        basicElements.remove();
        orderedTypes.addClass("merged");

        // Reset ordered types to be draggable
        var insertedItems = $(".question-types-menu .h-questionnaireItem.unset", questionnaireEditor.container);
        questionnaireEditor.setBlockItemsDraggable(insertedItems);
        insertedItems.removeClass("unset");
    }

    if ($(window).height() > 960) {
        orderedTypes.css("height", orderedTypes.hasClass("merged") ? "490px" : "250px");
    }
    else if ($(window).height() < 700) {
        orderedTypes.css("height", "250px");
    }
    else if ($(window).height() < 800) {
        orderedTypes.css("height", "330px");
    }
    else if ($(window).height() < 880) {
        orderedTypes.css("height", "410px");
    }
    else if ($(window).height() < 960) {
        orderedTypes.css("height", orderedTypes.hasClass("merged") ? "490px" : "250px");
    }
}

questionnaireEditor.setBlocksDraggable = function (elements) {
    elements.draggable({
        containment: questionnaireEditor.container, cursor: 'move', appendTo: "body", scrollSensitivity: 100, connectToSortable: "#blocksContainer", revert: "invalid",
        helper: function (event) {
            var target = $(event.currentTarget).clone();
            $(".v-subFolderList", target).remove();
            return '<ul class="question-types-menu dragged-item"><li>' + $(target).html() + '</li></ul>';
        }
    });
}

questionnaireEditor.setBlockItemsDraggable = function (elements) {
    var cursorPos = (a4.ie()) ? 130 : 50;

    elements.draggable({
        containment: questionnaireEditor.container,
        cursor: 'move',
        appendTo: "body",
        scrollSensitivity: 100,
        connectToSortable: ".v-questionsContainer",
        revert: "invalid",
        cursorAt: { left: cursorPos },
        start: function (event, ui) {
            questionnaireEditor.blockItemDragActive = true;
            questionnaireEditor.ensurePreviewIsHidden();
        },
        drag: function (event, ui) {
            if (questionnaireEditor.completedActionCallback) {
                questionnaireEditor.completedActionCallback = null;
                $(this).draggable("refreshContainment");
            }
        },
        stop: function () {
            questionnaireEditor.blockItemDragActive = false;
        },
        helper: function (event) {
            var target = $(event.currentTarget).clone();
            return '<ul id="currentDraggedElement" class="question-types-menu dragged-item"><li>' + $(target).html() + '</li></ul>';            
        }
    });
}

questionnaireEditor.setBlockItemsSortable = function (elements) {
    var dropCount = 0;

    var resetSortableView = function (draggable) {
        var currentBlock = draggable.closest(".v-blockPanel");

        currentBlock.removeClass("questionDragOver");
        $(".v-questionsContainer .item-divider", currentBlock).css("border-bottom-width", "1px");
        questionnaireEditor.questionController.adjustBlockDivisions(currentBlock);
        questionnaireEditor.blockController.ensureBlockInstructionsRemoved(currentBlock);

        draggable.show();
    }

    var onBlockItemSort = function (draggable, draggableContainer) {
        questionnaireEditor.blockItemDragActive = false;
        draggableContainer.hide();
        var insideBlock = draggableContainer.closest(".v-blockPanel");
        var previousItem = draggableContainer.prevAll(".v-blockItemPanel:first");
        var previousItemId = (previousItem.length > 0) ? questionnaireEditor.blockController.getBlockItemIdFromElement(previousItem) : null;
        var position = (previousItemId == null) ? 0 : null;

        if (insideBlock.length > 0 && $(".v-questionsContainer:visible", insideBlock).length > 0 && dropCount++ == 1) {
            if (draggable.hasClass("h-questionnaireItem")) {
                questionnaireEditor.questionController.createBlockItem(insideBlock, draggable.attr("data-id"), draggable.attr("data-section"), previousItemId, position,
                    function (result) {
                        questionnaireEditor.activeBlock = questionnaireEditor.blockController.getBlockIdFromElement(draggableContainer);
                        resetSortableView(draggableContainer);
                        draggableContainer.replaceWith(result);
                        _paq.push(['trackEvent', 'Survey-Edit-Questionnaire', 'Question Creation', draggable.find('.sprite-editor-icons').attr("title")]);
                    });
            }
            else if (draggable.hasClass("v-blockItemPanel")) {
                var currentBlockId = questionnaireEditor.blockController.getBlockIdFromElement(draggableContainer);
                questionnaireEditor.activeBlock = currentBlockId;

                if (draggable.index() != draggable.attr("data-index") || currentBlockId != draggable.attr("data-blockId")) {
                    var newBlockItem = draggableContainer.nextAll(".v-blockItemPanel:first");
                    var nextBlockItemId = (newBlockItem.length > 0) ? questionnaireEditor.blockController.getBlockItemIdFromElement(newBlockItem) : null;

                    var blockItemId = questionnaireEditor.blockController.getBlockItemIdFromElement(draggableContainer);
                    questionnaireEditor.questionController.moveBlockItem(blockItemId, draggable.attr("data-blockId"), currentBlockId, previousItemId, nextBlockItemId, (draggable.index() < draggable.attr("data-index")));
                }

                resetSortableView(draggableContainer);
            }
            else {
                resetSortableView(draggableContainer);
            }
        }
        else {
            resetSortableView(draggableContainer);
        }
    }

    elements.sortable({
        forcePlaceholderSize: true,
        handle: ".v-moveBlockItem",
        items: ".v-blockItemPanel",
        connectWith: ".v-questionsContainer",
        placeholder: "sortable-placeholder",
        start: function (event, ui) {
            questionnaireEditor.blockItemDragActive = true;
            dropCount = 1;
            var draggable = $(ui.item);

            if (draggable.hasClass("v-blockItemPanel")) {
                draggable.attr("data-blockId", questionnaireEditor.blockController.getBlockIdFromElement(draggable));
                draggable.attr("data-index", draggable.index());
                draggable.closest(".v-blockPanel").addClass("questionDragOver");

                var container = draggable.closest(".v-questionsContainer");
                $(".item-divider", container).css("border-bottom-width", "0px");
                questionnaireEditor.expandBlockTimer = 200;
            }
        },
        over: function (event, ui) {
            var currentBlock = $(this).closest(".v-blockPanel");

            if (!currentBlock.hasClass("questionDragOver")) {
                currentBlock.addClass("questionDragOver");
                $(".v-questionsContainer .item-divider", currentBlock).css("border-bottom-width", "0px");
            }
        },
        stop: function (event, ui) {
            var item = $(ui.item);
            onBlockItemSort(item, item);
        },
        receive: function (event, ui) {
            var draggable = $(ui.item);
            var draggableContainer = $(ui.helper);
            onBlockItemSort(draggable, draggableContainer);
        }
    });
}


// --------------- Questionnaire - events ----------------------------

questionnaireEditor.setQuestionnaireEvents = function () {
    questionnaireEditor.container.on("click", "#moveTo", function () {
        questionnaireEditor.showLocationDialog(questionnaireEditor.resources.MoveSelectedQuestions, false, null, null,
            function (moveToBlockId, moveLocation, moveQuestionId) {
                var items = questionnaireEditor.questionController.getSelectedQuestionsAndPageBreaks();
                questionnaireEditor.questionController.moveMultipleItems(items, moveToBlockId, moveLocation, moveQuestionId, items.length);
            });
    });

    questionnaireEditor.container.on("click", "#addSelectedToLibrary", function () {
        var showPopup = function () {
            var items = questionnaireEditor.questionController.getSelectedQuestions();
            var single = items.length <= 1;
            var useName = (single) ? $(".h-questionTitle", questionnaireEditor.blockController.getBlockItemElementFromId(_.first(items))).text() : null;

            questionnaireEditor.showAddToLibraryDialog(useName,
                function (newName, categoryId) {
                    questionnaireEditor.questionController.addQuestionsToLibrary(items, newName, categoryId, single, true);
                });
        }

        questionnaireEditor.loadQuestionCategories(showPopup);
    });

    questionnaireEditor.container.on("click", "#copySelected", function () {
        questionnaireEditor.showLocationDialog(questionnaireEditor.resources.CopySelectedQuestions, true, null, null,
        function (moveToBlockId, moveLocation, moveQuestionId, nbTimes) {
            var items = questionnaireEditor.questionController.getSelectedQuestionsAndPageBreaks();
            questionnaireEditor.questionController.copyBlockItems(moveToBlockId, moveLocation, moveQuestionId, items, nbTimes);
            questionnaireEditor.refreshQuestionnaireTotalCount(0, (_.size(items) * nbTimes));
        });
    });

    questionnaireEditor.container.on("click", "#deleteSelected", function () {
        var items = questionnaireEditor.questionController.getSelectedQuestionsAndPageBreaks();
        questionnaireEditor.questionController.deleteItems(items);
    });

    questionnaireEditor.container.on("click", "#activateSelectedQuestion", function () {
        var items = questionnaireEditor.questionController.getSelectedQuestions();
        questionnaireEditor.questionController.activateDeactivateQuestions(items, true);
    });

    questionnaireEditor.container.on("click", "#deactivateSelectedQuestion", function () {
        var items = questionnaireEditor.questionController.getSelectedQuestions();
        questionnaireEditor.questionController.activateDeactivateQuestions(items, false);
    });

    questionnaireEditor.container.on("click", ".v-expandAll", function () {
        var questionnaireModeRef;

        if (questionnaireEditor.isStructureViewMode) {
            questionnaireModeRef = questionnaireStructure;
            questionnaireStructure.expandAllBlocks = $(".v-blockStructurePanel:not(.loaded)", questionnaireModeRef.container);
        }
        else {
            questionnaireModeRef = questionnaireEditor;
            questionnaireEditor.expandAllBlocks = $(".v-blockPanel:not(.loaded)", questionnaireModeRef.container);
        }

        if (questionnaireModeRef.expandAllBlocks.length == 0) {
            questionnaireModeRef.completeExpandAll();
        }
        else {
            questionnaireModeRef.completeExpandAll();
            questionnaireModeRef.verifyAndLoadEmptyBlockedScolledIntoView();
            $(window).on("scroll", function (e) { questionnaireModeRef.verifyAndLoadEmptyBlockedScolledIntoView(); });
        }
    });

    questionnaireEditor.container.on("click", ".v-collapseAll", function () {
        var questionnaireModeRef;
        var blockPanelSelector;
        var questionContentSelector;
        if (questionnaireEditor.isStructureViewMode) {
            questionnaireModeRef = questionnaireStructure;
            blockPanelSelector = ".v-blockStructurePanel";
            questionContentSelector = ".v-structureQuestionContent";
        } else {
            questionnaireModeRef = questionnaireEditor;
            blockPanelSelector = ".v-blockPanel";
            questionContentSelector = ".v-editQuestionContent";
        }

        $(blockPanelSelector + ":not(.loading) .v-questionsContainer:visible", questionnaireModeRef.container).each(function () {
            var block = $(this).closest(blockPanelSelector);
            var questions = $(questionContentSelector + ":visible", block);
            questionnaireModeRef.initializeExpandCollapse(questions);
            questionnaireModeRef.toggleBlock($(this), false, function () { questionnaireModeRef.blockMouseLeave(block); });
        });

        questionnaireModeRef.expandAllBlocks = [];
    });

    var radios = $(".v-questionnaireModeSwitcher input:radio");

    $(".v-questionnaireModeSwitcher input:radio").on("change", function () {
        questionnaireEditor.switchViewMode($("input:radio[name='questionnaireMode']:checked").val());
    });

    questionnaireEditor.container.on("click", ".v-printSurvey", function () {
        modalDialog.showWindow(questionnaireEditor.getUrl("Print"), 750, 1000);
    });

    questionnaireEditor.container.on("click", ".h-backtotop", function () {
        $(window).scrollTop(0);
    });
}

// --------------- Blocks - Functions ------------------------------------
//The following functions have to be defined in the questionnaireEditor, 
//because of the usage of dynamic variable calls with either questionnaireEditor or questionnaireStructure.
//The following functions can be removed when questionnaireStructure is scoped and no calls are done on dynamic variables.

questionnaireEditor.blockMouseLeave = function (blockPanel) {
    questionnaireEditor.blockController.blockMouseLeave(blockPanel);
}

questionnaireEditor.toggleBlock = function (button, findQuestion, callback, noMoveOnCallback) {
    questionnaireEditor.blockController.toggleBlock(button, findQuestion, callback, noMoveOnCallback);
}

questionnaireEditor.loadBlockContent = function (id, blockPanel, openBlock, findQuestion, callback, toggle) {
    questionnaireEditor.blockController.loadBlockContent(id, blockPanel, openBlock, findQuestion, callback, toggle);
}

questionnaireEditor.completeButtonToggle = function (id, blockPanel, openBlock, findQuestion, callback) {
    questionnaireEditor.blockController.completeButtonToggle(id, blockPanel, openBlock, findQuestion, callback);
}

questionnaireEditor.initializeExpandCollapse = function (questions) {
    questionnaireEditor.blockController.initializeExpandCollapse(questions);
}

questionnaireEditor.executeExpandCollapse = function (questions) {
    questionnaireEditor.blockController.executeExpandCollapse(questions);
}

questionnaireEditor.expandCollapseBlockItem = function (questionContent) {
    questionnaireEditor.blockController.expandCollapseBlockItem(questionContent);
}

questionnaireEditor.getBlockIdFromElement = function (item) {
    return questionnaireEditor.blockController.getBlockIdFromElement(item);
}

questionnaireEditor.getBlockElementFromId = function (itemId) {
    return questionnaireEditor.blockController.getBlockElementFromId(itemId);
}

questionnaireEditor.getBlockItemElementInBlockWithId = function (block, itemId) {
    return questionnaireEditor.blockController.getBlockItemElementInBlockWithId(block, itemId);
}

// --------------- Questions - Functions ------------------------------------
//The following functions have to be defined in the questionnaireEditor, 
//because of the usage of dynamic typing calls with either questionnaireEditor or questionnaireStructure.
//These functions can be removed when questionnaireStructure is scoped and no calls are done on dynamic variables.

questionnaireEditor.verifyAndLoadEmptyBlockedScolledIntoView = function () {
    questionnaireEditor.questionController.verifyAndLoadEmptyBlockedScolledIntoView();
}

questionnaireEditor.completeExpandAll = function () {
    questionnaireEditor.questionController.completeExpandAll();
}

questionnaireEditor.toggleQuestion = function (button, withSave) {
    questionnaireEditor.questionController.toggleQuestion(button, withSave);
}

// --------------- Misc ajax functions ---------------------------------------------------------------

questionnaireEditor.importLibraryCategory = function (categoryId, sectionName, previousBlockId, position, callback) {
    a4.callServerMethod(questionnaireEditor.getUrl("ImportLibraryCategory"), { categoryId: categoryId, section: sectionName, previousBlockId: previousBlockId, atPosition: position, nbQuestions: _.size(questionnaireEditor.questions) },
        function (result) {
            questionnaireEditor.blockController.completeAddBlock(result, callback);
        });
}

// --------------- Editor general actions Save/Edit/Cancel/Close ------------------------------------

questionnaireEditor.executeQueue = function () {
    while (questionnaireEditor.queueSyncCalls.length > 0) {
        var nextFunc = questionnaireEditor.queueSyncCalls.shift();
        nextFunc();
    }
}


questionnaireEditor.keepPageActive = function () {
    // Do not reload the frame if it has not yet been loaded
    var frame = $("#SessionKeepAliveFrame");
    var releaseMode = (document.location.hostname !== "localhost");

    if (frame.length && frame.contents().length && releaseMode && frame.contents()[0].readyState === "complete")
        frame[0].contentWindow.location.reload();
}

questionnaireEditor.executeGlobalCallback = function (clearValues) {
    clearValues = (typeof clearValues === "undefined") ? true : clearValues;

    if (questionnaireEditor.completedActionCallback) {
        questionnaireEditor.completedActionCallback();
        questionnaireEditor.completedActionCallback = null;
    }

    if (clearValues) {
        questionnaireEditor.clearEditValues();
    }
}

questionnaireEditor.closeEditQuestion = function () {
    var item = questionnaireEditor.getInEditQuestion();
    if (item.length > 0) {
        var panel = item.closest(".v-blockItemPanel");
        var questionType = $(".v-questionEdit", panel).attr("data-qtypename");
        $(".v-questionEdit", panel).hide();
        $(".v-questionDisplay", panel).show();
        $(".v-questionLogic", panel).show();
        $(".v-npsPreviewFeedbackQuestion", panel).show();
        panel.removeData();                 // Removed keys include ("askLogic", "skipLogic", "preLoad", "postAnswer")   
        panel.removeClass("inEdit");
        panel.find(".editorTabs").remove();
        var editorContainer = $('.question-editor-container, .v-questionEditorContainer', panel)[0].innerHTML = "";
        panel.trigger("mouseenter");
        questionnaireEditor.setDisplayQuestionTypePreview(panel, questionType, true);
        questionnaireEditor.hideTooltip(); // hide text highlight tooltip
    }
}

questionnaireEditor.closeEditQuestionTitle = function () {
    var questionitem = questionnaireEditor.getInEditQuestionTitle();

    if (questionitem.length > 0) {
        var editInput = questionitem.find("input[type=text]");
        var cancelButton = questionitem.find(".v-questionTitleEditCancel");
        var confirmButton = questionitem.find(".v-questionTitleEditConfirm");
        var loadingIcon = questionitem.find(".v-questionTitleEditLoading");
        var questionTitleEditZone = questionitem.find(".v-questionTitleEditZone");

        questionitem.removeClass("inEditTitle");
        cancelButton.remove();
        confirmButton.remove();
        loadingIcon.remove();
        editInput.remove();
        questionTitleEditZone.show();
    }
}

questionnaireEditor.cancelEditQuestion = function () {
    var panel = questionnaireEditor.getInEditQuestion();

    // Verify that we were editing a question
    if (panel.length > 0) {
        panel = panel.closest(".v-blockItemPanel");

        if (_.some(questionnaireEditor.editComputeVariables, function (v) { return v.newName != '' || v.deleted; })) {
            questionnaireEditor.undoQuestionComputeVariablesChanges(questionnaireEditor.blockController.getBlockItemIdFromElement(panel));
        }

        if (questionnaireEditor.disabledDateControl != null)
            questionnaireEditor.disabledDateControl.clearAll();
        questionnaireEditor.clearEditValues();
    }


    questionnaireEditor.closeEditQuestion();
}

questionnaireEditor.cancelEditQuestionTitle = function () {
    var panel = questionnaireEditor.getInEditQuestionTitle();

    // Verify that we were editing a question title
    if (panel.length > 0) {
        questionnaireEditor.clearEditValues();
    }

    questionnaireEditor.closeEditQuestionTitle();
}

questionnaireEditor.savePreviouslyEditedItem = function () {
    var saveButton = $(".buttons-section input:visible, .v-questionTitleEditConfirm, .v-blockTitleEditConfirm", questionnaireEditor.container);
    saveButton.trigger("click");
    questionnaireEditor.buttonClick = true;
}

questionnaireEditor.cancelPreviouslyEditedItem = function () {
    questionnaireEditor.blockController.cancelEditBlock();
    questionnaireEditor.cancelEditQuestion();
    questionnaireEditor.cancelEditQuestionTitle();
    questionnaireEditor.blockController.cancelEditBlockTitle();
    questionnaireEditor.buttonClick = true;
}

questionnaireEditor.closePreviouslyEditedItem = function () {
    var blockPanel = $(".v-editBlockContent:visible", questionnaireEditor.container);
    var blockItemPanel = $(".v-questionsContainer .inEdit:visible", questionnaireEditor.container);
    var blockItemTitlePanel = $(".v-blockItemPanel .v-questionTitleGroup.inEditTitle:visible", questionnaireEditor.container);
    var blockTitlePanel = $(".v-blockPanel .v-blockTitleGroup.inEditTitle:visible", questionnaireEditor.container);

    if (blockPanel.length > 0) {
        questionnaireEditor.blockController.closeEditBlock();
    }
    else if (blockItemPanel.length > 0) {
        questionnaireEditor.closeEditQuestion();
    }
    else if (blockItemTitlePanel.length > 0) {
        questionnaireEditor.closeEditQuestionTitle();
    }
    else if (blockTitlePanel.length > 0) {
        questionnaireEditor.blockController.closeEditBlockTitle();
    }

    questionnaireEditor.clearEditValues();
}

questionnaireEditor.removeReferencedBanners = function (id, isQuestion) {
    if (isQuestion) {
        $(".v-logicBanner[data-actiontype='BranchTo'][data-reference='" + id + "'],.v-logicBanner[data-actiontype='SetVariableValue'][data-reference='" + id + "']", questionnaireEditor.container).each(function () {
            $(this).remove();
        });
    }
    else {
        $(".v-logicBanner[data-actiontype='SetLoopRow'][data-reference='" + id + "']", questionnaireEditor.container).each(function () {
            $(this).remove();
        });
    }
}

questionnaireEditor.unloadEditedPanels = function () {
    $(".v-blockItemPanel.edited:not(.inEdit)", questionnaireEditor.container).each(function () {
        questionnaireEditor.unloadQuestionEditPanel($(this));
    });

    $(".v-blockItemPanel.inEdit", questionnaireEditor.container).each(function () {
        $(this).addClass("needsReload");
    });
}

questionnaireEditor.unloadQuestionEditPanel = function (blockItemPanel) {
    blockItemPanel.removeClass("edited");
    $(".v-questionEditorContainer", blockItemPanel).html("");
}

questionnaireEditor.cleanupSkipLogicEditorAfterSave = function (panel, syntaxType) {
    if (syntaxType == "Advanced") {
        $(".v-skipLogicContainer .v-logicBody .v-questionEditableItem", panel).remove();
    }
    else {
        $(".v-skipLogicContainer .v-advanceCondition", panel).val("");
    }
}

questionnaireEditor.checkSurveyMenuStatus = function () {
    var surveyHeader = $(".v-surveyHeader");
    var lastChangesCont = $(".v-lastChanges", surveyHeader);
    var updateLiveVersionLink = $(".h-deployAction", lastChangesCont);

    if (updateLiveVersionLink.length == 0) {
        surveyMenu.refresh();
    }
    else {
        var currentdate = new Date();
        var hours = currentdate.getHours();

        var mid = currentdate.getHours() < 12 ? 'AM' : 'PM';

        if (hours > 12) {
            hours -= 12;
        }
        else if (hours === 0) {
            hours = 12;
        }

        var datetime = (currentdate.getMonth() + 1) + "/"
            + currentdate.getDate() + "/"
            + currentdate.getFullYear() + " "
            + hours + ":"
            + currentdate.getMinutes() + ":"
            + ('0' + currentdate.getSeconds()).slice(-2) + " " + mid;

        $(".v-date", lastChangesCont).html(datetime);
    }
}

questionnaireEditor.refreshQuestionnaireTotalCount = function (incBlocks, incQuestions) {
    questionnaireEditor.nbBlocks += incBlocks;
    questionnaireEditor.nbQuestions += incQuestions;
    var text = questionnaireEditor.resources.QuestionnaireTotal.replace("{0}", questionnaireEditor.nbBlocks).replace("{1}", questionnaireEditor.nbQuestions);
    $(".qTotals", questionnaireEditor.container).text(text);
}

// --------------- SETTINGS FUNCTIONS ------------------------------------

questionnaireEditor.loadSystemChoices = function () {
    a4.callServerMethod(questionnaireEditor.getUrl("GetSystemChoices"), {}, function (result) {
        $.each(result, function (index, item) {
            if (item.Type == 0) {
                questionnaireEditor.languages.push({ value: item.Key, name: item.Value });
            }
            else {
                questionnaireEditor.timeZones.push({ value: item.Key, name: item.Value });
            }
        });
    });
}

questionnaireEditor.loadQuestionCategories = function (callback) {
    if (questionnaireEditor.questionCategories == null) {
        a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionCategories"), {},
           function (result) {
               questionnaireEditor.questionCategories = result;
               callback();
           });
    }
    else {
        callback();
    }
}

questionnaireEditor.loadVariablesChoices = function (choiceListId, variableName, questionId, blockId, callback) {
    var args = { choiceListId: choiceListId, variableName: variableName, questionId: questionId, blockId: blockId };

    a4.callServerMethod(questionnaireEditor.getUrl("GetVariableChoices"), args,
        function (result) {
            if (!_.some(questionnaireEditor.choices, function (c) { return c.variableName == variableName; })) {
                questionnaireEditor.addItemsToSettings(result);
            }

            callback();
        });
}

questionnaireEditor.loadQuestionnaireActions = function (callback) {
    questionnaireEditor.actions = [];

    a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionnaireActions"), {},
        function (result) {
            questionnaireEditor.addItemsToSettings(result);
            questionnaireEditor.actionsLoaded = true;
            callback();
        });


}

questionnaireEditor.setQuestionnaireData = function () {
    var defaultTimeout = a4.busyBoxTimeout;
    a4.busyBoxTimeout = 4000;

    a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionnaireInitialData"), {},
        function (result) {
            questionnaireEditor.addItemsToSettings(result);
            questionnaireEditor.loadSystemChoices();
            questionnaireEditor.refreshQuestionnaireTotalCount(_.size(questionnaireEditor.blocks), _.size(questionnaireEditor.questions));
        }
    );

    a4.busyBoxTimeout = defaultTimeout;

    /* questionnaireEditor.addItemsToSettings(questionnaireEditor.data);
     questionnaireEditor.data = null;*/
}

questionnaireEditor.addItemsToSettings = function (result) {
    $.each(result, function (index, item) {

        // 0-Block, 1-Question, 2-QuestionType, 3-Variable, 4-Choice, 5-PreLoadAction, 6-PostAnswerAction
        switch (item.Type) {
            case 0: questionnaireEditor.blocks.push({ value: item.Value, name: item.Name, blockId: item.BId, position: item.Pos }); break;
            case 1: questionnaireEditor.questions.push({ value: item.Value, name: item.Name, type: item.QType, choiceListId: item.CLId, questionId: item.QId, position: item.Pos, blockId: item.BId, blockPosition: item.BlockPos, active: item.QActive }); break;
            case 2: questionnaireEditor.questionTypes.push({ value: item.Value, name: item.Name, label: item.Label }); break;
            case 3: questionnaireEditor.variables.push({ value: item.Value, name: item.Name, type: item.VType, isSecuredTemporaryVariable: item.VIsSecuredTemporaryVariable, choiceListId: item.CLId, questionId: item.QId, blockId: item.BId, qType: item.QType }); break;
            case 4: questionnaireEditor.choices.push({ value: item.Value, name: item.Label, variableName: item.Name, questionId: item.QId, blockId: item.BId }); break;
            case 5: questionnaireEditor.actions.push({ value: item.Value, name: item.Name, summary: item.Label, type: 0, position: item.Pos, questionId: item.QId, questionName: item.QName, blockId: item.BId }); break;
            case 6: questionnaireEditor.actions.push({ value: item.Value, name: item.Name, summary: item.Label, type: 1, position: item.Pos, questionId: item.QId, questionName: item.QName, blockId: item.BId }); break;
        }
    });
}

// For block we execute the global callback only for save -> no cleanup or update required
questionnaireEditor.updateBlockSettings = function (blockId, cleanup, withUpdate) {
    if (cleanup) {
        questionnaireEditor.removeBlockFromSettings(blockId);
    }

    if (withUpdate) {
        questionnaireEditor.loadBlockSettings(blockId);
    }

    if (!cleanup && !withUpdate) {
        questionnaireEditor.executeGlobalCallback();
    }

    questionnaireEditor.checkSurveyMenuStatus();
}

questionnaireEditor.loadBlockSettings = function (blockId) {
    a4.callServerMethod(questionnaireEditor.getUrl("GetBlockValues"), { blockId: blockId },
        function (result) {
            questionnaireEditor.addItemsToSettings(result.d);
            //RefreshBlockHeaderCount($("#block" + blockId, questionnaireEditor.container));            
        });
}

questionnaireEditor.removeBlockFromSettings = function (blockId) {
    questionnaireEditor.blocks = _.reject(questionnaireEditor.blocks, function (block) { return block.blockId == blockId; });
    questionnaireEditor.questions = _.reject(questionnaireEditor.questions, function (question) { return question.blockId == blockId; });
    questionnaireEditor.variables = _.reject(questionnaireEditor.variables, function (variable) { return variable.blockId == blockId; });
    questionnaireEditor.choices = _.reject(questionnaireEditor.choices, function (choice) { return choice.blockId == blockId; });
    questionnaireEditor.actions = _.reject(questionnaireEditor.actions, function (action) { return action.blockId == blockId; });
}

questionnaireEditor.removeQuestionFromSettings = function (questionId) {
    questionnaireEditor.questions = _.reject(questionnaireEditor.questions, function (question) { return question.questionId == questionId; });
    questionnaireEditor.variables = _.reject(questionnaireEditor.variables, function (variable) { return variable.questionId == questionId; });
    questionnaireEditor.choices = _.reject(questionnaireEditor.choices, function (choice) { return choice.questionId == questionId; });
    questionnaireEditor.actions = _.reject(questionnaireEditor.actions, function (action) { return action.questionId == questionId; });
}

// For questions we execute the global callback in load -> save triggers callback for add/update question both withUpdate
questionnaireEditor.updateQuestionSettings = function (questionId, existingQuestion, withUpdate, unload) {
    var leaveEdition = (unload == undefined || unload);
    var previousVariables = null;

    if (leaveEdition) {
        questionnaireEditor.unloadEditorPanels();
    }

    if (existingQuestion) {
        previousVariables = questionnaireEditor.getVariablesByQuestionId(questionId);
        previousName = questionnaireEditor.getQuestionById(questionId).name;
        questionnaireEditor.removeQuestionFromSettings(questionId);
    }

    if (withUpdate) {
        var callback = null;

        if (previousVariables != null) {
            callback = function () { questionnaireEditor.propagateVariableChanges(questionId, previousVariables); questionnaireEditor.propagateNameChange(questionId, previousName); };
        }

        questionnaireEditor.loadQuestionSettings(questionId, leaveEdition, callback);
    }

    questionnaireEditor.checkSurveyMenuStatus();

    //For piping editor.
    a4.surveyVariables = null;
}

questionnaireEditor.loadQuestionSettings = function (questionId, leaveEdition, callback) {
    a4.callServerMethod(questionnaireEditor.getUrl("GetQuestionValues"), { questionId: questionId },
        function (result) {
            questionnaireEditor.addItemsToSettings(result);
            questionnaireEditor.executeGlobalCallback();

            if (!leaveEdition) {
                var panel = questionnaireEditor.getInEditQuestion();
                questionnaireEditor.setEditStartValues(panel, $(".v-questionEdit", panel).attr("data-qtypename"));
            }

            if (callback != null) {
                callback();
            }
        });
}

questionnaireEditor.undoQuestionComputeVariablesChanges = function (questionId) {
    questionnaireEditor.removeQuestionFromSettings(questionId);

    a4.callServerMethod(questionnaireEditor.getUrl("UndoComputeVariablesChanges"), { questionId: questionId, computeVariablesData: JSON.stringify(questionnaireEditor.editComputeVariables) },
        function (result) {
            questionnaireEditor.addItemsToSettings(result);
        });
}

questionnaireEditor.clearEditValues = function () {
    questionnaireEditor.editTexts = {};
    questionnaireEditor.editValues = {};
    questionnaireEditor.editChoices = {};
}

questionnaireEditor.propagateVariableChanges = function (questionId, oldVariables) {
    var newVariables = questionnaireEditor.getVariablesByQuestionId(questionId);

    _.each(oldVariables, function (v) {
        var i = _.find(newVariables, function (ve) { return ve.value == v.value; });

        if (i !== undefined) {
            questionnaireEditor.changeBannerReference(v.name, i.name);
        }
    });
}

questionnaireEditor.propagateNameChange = function (questionId, oldName) {
    var newName = questionnaireEditor.getQuestionById(questionId).name;
    questionnaireEditor.changeBannerReference(oldName, newName);
}

questionnaireEditor.propagateComputeVariableChanges = function () {
    _.each(questionnaireEditor.editComputeVariables, function (v) {
        if (v.name != "" && v.newName != "" && v.name != v.newName) {
            questionnaireEditor.changeBannerReference(v.name, v.newName);
        }
    });
}

questionnaireEditor.changeBannerReference = function (prevName, newName) {
    $(".v-bannerResume:contains('" + prevName + "')", questionnaireEditor.container).each(function () {
        var newText = " " + $(this).text() + " ";                               // Pad for cases where variable is first or last character in text
        newText = newText.replace(" " + prevName + " ", " " + newName + " ");      // Complete variable name - space before and after
        $(this).text(newText.trim());
    });
}

questionnaireEditor.unloadEditorPanels = function () {
    $(".questionLogicPanel, .blockAdvanceOptions", questionnaireEditor.container).each(function () {
        if ($(this).html() != "") {
            $(this).html("");
        }
    });

    $(".v-blockItemPanel", questionnaireEditor.container).each(function () {
        questionnaireEditor.unloadQuestionEditorPanels($(this));
    });
}

questionnaireEditor.unloadQuestionEditorPanels = function (container) {


    var editorPanel = $(".v-questionEditorContainer", container);
    if (editorPanel.length > 0 && editorPanel.html() != "") {
        editorPanel.html("");
    }

    /*var quickEditorPanel = $(".questionQuickEditorContainer", container);
    if (quickEditorPanel.length > 0 && quickEditorPanel.html() != "") {
        quickEditorPanel.html("");
    }

    var advancedOptionsPanel = $(".questionAdvanceOptions", container);
    if (advancedOptionsPanel.length > 0 && advancedOptionsPanel.html() != "") {
        var questionAdvance = advancedOptionsPanel.closest(".questionAdvance");
        questionAdvance.removeClass("opened");

        $(".expandButton", questionAdvance).show();
        $(".collapseButton", questionAdvance).hide();

        advancedOptionsPanel.html("");
    }*/
}

questionnaireEditor.loadPanelData = function (initFunc) {
    if (questionnaireEditor.panels != null) {
        initFunc();
    }
    else {
        questionnaireEditor.panels = [];
        questionnaireEditor.panelAttributes = [];

        var callbacks = $.Callbacks();
        callbacks.add(questionnaireEditor.retrievePanel);
        callbacks.add(questionnaireEditor.retrievePanelAttributes);
        callbacks.add(initFunc);

        callbacks.fire();

        /*questionnaireEditor.queueSyncCalls.push(function () { questionnaireEditor.retrievePanel(); });
        questionnaireEditor.queueSyncCalls.push(function () { questionnaireEditor.retrievePanelAttributes(initFunc); });

        questionnaireEditor.executeQueue();*/
    }
}

questionnaireEditor.retrievePanel = function () {
    a4.callServerMethod(questionnaireEditor.getUrl("GetPanels"), {},
        function (result) {
            $.each(result, function (index, item) {
                questionnaireEditor.panels.push({ value: item.Id, name: item.Name, requiredFields: item.RequiredFields });
            });
        });
}

questionnaireEditor.retrievePanelAttributes = function () {
    a4.callServerMethod(questionnaireEditor.getUrl("GetPanelAttributes"), {},
        function (result) {
            $.each(result, function (index, item) {
                questionnaireEditor.panelAttributes.push({ value: item.Id, name: item.Name, panelId: item.PanelId, isRequired: item.IsRequired });
            });
        });
}

// --------------- Compute Variable synchronization -------------------------

/// Manage the compute variables related to the question
///  We must serialize the variables before changes are commited since compute variables can be used directly in other actions for the question
///  The editComputeVariables is used to keep track of changes made. As soon as a change is made and the user does a cancel we must undo our changes in the database 
questionnaireEditor.updateVariableList = function (existingVarName, newVarName, questionId) {
    var existingVar = questionnaireEditor.getVariableByName(existingVarName);
    var index = _.indexOf(questionnaireEditor.variables, existingVar);

    // Delete variable case
    if (newVarName == null && index != -1) {
        questionnaireEditor.variables.splice(index, 1);
        questionnaireEditor.cleanupComputeVariablesOfQuestion(existingVar.questionId, existingVarName);
        var itemBeforeEdit = _.find(questionnaireEditor.editComputeVariables, function (v) { return v.name.toUpperCase() == existingVarName.toUpperCase(); });

        if (itemBeforeEdit) {
            itemBeforeEdit.deleted = true;
        }
        else {
            questionnaireEditor.editComputeVariables = _.reject(questionnaireEditor.editComputeVariables, function (v) { return v.newName.toUpperCase() == existingVarName.toUpperCase(); });
        }
    }
    else {
        var itemBeforeEdit = _.find(questionnaireEditor.editComputeVariables, function (v) { return v.name.toUpperCase() == newVarName.toUpperCase(); });
        var question = questionnaireEditor.getQuestionById(questionId);

        // Update
        if (index != -1) {
            if (!itemBeforeEdit) {
                questionnaireEditor.renameVariableOfComputeVariableAction(questionId, newVarName, existingVar);
                itemBeforeEdit = _.find(questionnaireEditor.editComputeVariables, function (v) { return v.name.toUpperCase() == existingVarName.toUpperCase() || v.newName.toUpperCase() == existingVarName.toUpperCase(); });
            }
            else {
                existingVar.name = newVarName;
            }

            itemBeforeEdit.newName = newVarName;
        }
            // Create 
        else if (newVarName != null) {
            // If existed before we started to edit the logic then add. Otherwise persist a new variable
            if (itemBeforeEdit) {
                questionnaireEditor.variables.push({ value: itemBeforeEdit.value, name: newVarName, type: 2, questionType: 0, choiceListId: 0, questionId: questionId, blockId: question.blockId });
            }
            else {
                questionnaireEditor.createNewVariableForComputeVariableAction(question, newVarName);
                questionnaireEditor.editComputeVariables.push({ name: '', newName: newVarName, deleted: false });
            }
        }
    }
}

questionnaireEditor.createNewVariableForComputeVariableAction = function (question, variableName) {
    a4.callServerMethod(questionnaireEditor.getUrl("CreateComputeVariable"), { questionId: question.value, variableName: variableName },
        function (variableId) {
            questionnaireEditor.variables.push({ value: variableId, name: variableName, type: 2, questionType: 0, choiceListId: 0, questionId: question.value, blockId: question.blockId });
        },
        function (error) {
            questionnaireEditor.errorOnRequest = true;
            a4.onAjaxPageMethodError(error);
        });
}

questionnaireEditor.createComputeVariableActionCopy = function (questionId, actionId, variableName, callback) {
    a4.callServerMethod(questionnaireEditor.getUrl("CreateComputeVariableActionCopy"), { questionId: questionId, actionId: actionId, variableName: variableName },
        function (result) {
            var question = a4.top().questionnaireEditor.getQuestionById(questionId);
            questionnaireEditor.variables.push({ value: result.Id, name: result.Value, type: 2, questionType: 0, choiceListId: 0, questionId: questionId, blockId: question.blockId });
            questionnaireEditor.editComputeVariables.push({ name: '', newName: result.Value, deleted: false });

            if (callback)
                callback(result);
        },
        function (error) {
            questionnaireEditor.errorOnRequest = true;
            a4.onAjaxPageMethodError(error);
        });
}

questionnaireEditor.renameVariableOfComputeVariableAction = function (questionId, variableName, existingVar) {
    var args = { questionId: questionId, variableId: existingVar.value, variableName: variableName }
    a4.callServerMethod(questionnaireEditor.getUrl("RenameComputeVariableOfNonPersistedAction"), args,
        function (result) {
            existingVar.name = variableName;
        },
        function (error) {
            questionnaireEditor.errorOnRequest = true;
            a4.onAjaxPageMethodError(error);
        });
}

questionnaireEditor.cleanupComputeVariablesOfQuestion = function (questionId, variableName) {
    a4.callServerMethod(questionnaireEditor.getUrl("DeleteComputeVariablesOfNonPersistedAction"), { questionId: questionId, variableName: variableName }, function () { }, function () { });
}

questionnaireEditor.addComputeVariable = function (item, questionId) {
    var question = questionnaireEditor.getQuestionById(questionId);
    questionnaireEditor.variables.push({ value: item.VariableId, name: item.Value, type: 2, questionType: 0, choiceListId: 0, questionId: questionId, blockId: question.blockId });
    questionnaireEditor.editComputeVariables.push({ name: '', newName: item.Value, deleted: false });
}

questionnaireEditor.setEditComputeVariables = function () {
    questionnaireEditor.editComputeVariables = [];

    _.each(_.filter(questionnaireEditor.variables, function (v) { return v.type == 2; }), function (cv) {
        questionnaireEditor.editComputeVariables.push({ name: cv.name, newName: '', deleted: false });
    });
}

// --------------- Questionnaire editing values -------------------------

questionnaireEditor.setEditStartValues = function (panel, questionType) {
    if (!questionnaireEditor.isReadonly()) {
        questionnaireEditor.currentEditor = null;
        questionnaireEditor.editTexts = {};
        questionnaireEditor.editValues = {};
        questionnaireEditor.editChoices = {};

        questionnaireEditor.appendStartValuesForPanel(panel);

        if (questionnaireEditor.isGridQuestionType(questionType)) {
            questionnaireEditor.currentEditor = $(".gridEditor", panel).gridEditor();
        }

        a4.fixPostForInput(panel);
    }
}

questionnaireEditor.getItemValue = function (item) {
    if (item.is(".v-softPromptChoice")) {
        return item.data("value");
    }
    else
        return a4.getInputValue(item);
}

questionnaireEditor.appendStartValuesForPanel = function (panel) {
    FixPostForInput(panel);

    // For edit block and edit questions we save the name in our start values
    if (panel.hasClass("v-blockItemPanel") || panel.hasClass("v-editBlockContent")) {
        var item = (panel.hasClass("v-blockItemPanel")) ? $(".v-questionName", panel) : $(".nameText", panel);
        questionnaireEditor.editValues[item.attr("id")] = questionnaireEditor.getItemValue(item);
    }

    // Add synchronize question name - not a setting only for display - setting is Id
    var syncQName = $(".v-randomizationSynchQuestionValueName", panel);
    if (syncQName.length > 0) {
        questionnaireEditor.editValues[syncQName.attr("id")] = syncQName.val();
    }

    $(".v-setting, .v-translatableSetting, .v-variableSetting", panel).each(function () {
        var ref = $(this).attr("id") ? $(this).attr("id") : $(this).attr("data-name");
        if (ref /*&& questionnaireEditor.editTexts[ref] == undefined*/) {
            questionnaireEditor.editValues[ref] = questionnaireEditor.getItemValue($(this));
        }
    });

    $(".v-choiceSetting", panel).each(function () {
        if ($(this).closest(".v-newItem").length == 0) {
            questionnaireEditor.editChoices[$(this).attr("id")] = questionnaireEditor.getItemValue($(this));
        }
    });

    // For skip logic and randomization 
    $(".v-conditionControl :input:visible, .v-conditionControl input[type='hidden'], .v-conditionControl select:visible", panel).each(function () {
        questionnaireEditor.editValues[$(this).attr("id")] = $(this).val();
    });
}

questionnaireEditor.resetEditStartValues = function (panel) {
    // For edit block and edit question
    if (panel.hasClass("v-blockItemPanel") || panel.hasClass("v-blockPanel")) {
        var item = (panel.hasClass("v-blockItemPanel")) ? $(".v-questionName", panel) : $(".nameText", panel);
        item.val(questionnaireEditor.editValues[item.attr("id")]);
    }

    var itemValue = null;
    $(".v-setting, .v-translatableSetting, .v-variableSetting", panel).each(function () {
        var item = $(this);
        var name = item.attr("id") ? item.attr("id") : item.attr("data-name");

        if (questionnaireEditor.editValues[name] != undefined) {
            itemValue = questionnaireEditor.editValues[name];

            if (item.is("input:checkbox")) {
                if (itemValue) {
                    item.prop("checked", true);
                }
                else {
                    item.prop("checked", false);
                }

                if (item.hasClass("questionActivate")) {
                    var questionName = item.closest(".v-blockItemPanel").find(".questionNameItem");
                    if (itemValue) {
                        questionName.removeClass("inactive");
                    }
                    else {
                        questionName.addClass("inactive");
                    }
                }
            }
            else if (item.is(".rich-text-editor")) {
                item.a4richTextEditor("setContent", itemValue);
            }
            else if (item.is("span") || item.is(".v-qeRichEditText")) {
                item.html(itemValue);
            }
            else if (item.is(".v-minMaxSettings")) {
                item.val(itemValue);
                questionnaireEditor.setMinMaxInitialValue(item.parent());
            }
            else if (item.is("input:hidden")) {
                item.val(itemValue);
                var input = $("input:text:visible", item.parent());

                if (input.length > 0) {
                    input.val(itemValue);
                }
            }
            else if (item.is(".v-softPromptChoice")) {
                item.a4autocomplete("setValue", itemValue);
            }
            else {
                var inital = item.val();

                if (item.hasClass("withFocus") && inital != itemValue) {
                    item.trigger("focusin");
                    item.val(itemValue);
                    item.trigger("focusout");
                }
                else {
                    item.val(itemValue);

                    if (item.is("select")) {
                        item.trigger("change");
                    }
                }
            }

            /*if ($(this).parent().is(".v-dimensionSelectorContainer")) {
                questionnaireEditor.updateDimensionSelectorValue($(this));
            }*/
        }
    });

    // Reset sync question name - if present after select was reset
    var syncQName = $(".v-randomizationSynchQuestionValueName", panel);
    if (syncQName.length > 0) {
        syncQName.val(questionnaireEditor.editValues[syncQName.attr("id")]);
    }

    $(".v-choiceSetting", panel).each(function () {
        if (questionnaireEditor.editChoices[$(this).attr("id")] != undefined) {
            itemValue = questionnaireEditor.editChoices[$(this).attr("id")];

            if ($(this).is("input:checkbox")) {
                if (itemValue) { $(this).prop('checked', true); }
                else { $(this).prop('checked', false); }
            }
            else if ($(this).is("span")) {
                $(this).html(itemValue);
            }
            else {
                $(this).val(itemValue);
            }
        }
    });

    questionnaireEditor.resetLogicStartValues(panel);

    var questionName = $(".questionTitle", panel).text().trim();
    var choiceListEditor = $(".v-choiceListEditor", panel);

    $(".v-useSameAsPanel .v-choiceListId", choiceListEditor).each(function () {
        var choiceListId = $(this).val();

        if (choiceListId != null && $(this).data("sharedid")) {
            var questionId = questionnaireEditor.blockController.getBlockItemIdFromElement(panel);
            var variableName = questionnaireEditor.getVariableWithSameChoiceList(questionId, choiceListId);
            $(".v-selectQuestion", choiceListEditor).val(variableName);
            questionnaireEditor.setUseChoiceListIdAfterChange(choiceListEditor, $(this), choiceListId, null, variableName)
        }
    });

    // If more than one choice list than show the right one
    if ($(".v-useSameAsPanel .v-choiceListId", choiceListEditor).length > 1) {
        $(".v-choiceListBody .v-questionEditableItem:visible", choiceListEditor).hide();
        var selectedVar = $(".v-choicesByDropdown option:selected", choiceListEditor).attr("data-value");
        $(".v-choiceListBody .v-questionEditableItem[data-variable='" + selectedVar + "']", choiceListEditor).show();
    }

    //For image mage / image area selector
    if ($(".v-questionEdit .imageMap", panel).length > 0) {

        //Show the deleted areas
        $(".v-questionEdit .imageMap .area", panel).each(function () {
            var originalIndex = $(this).attr("data-originalindex");

            if (originalIndex) {
                $(this).attr("data-index", originalIndex);
                $(this).find(".areaText").html(originalIndex);
                $(this).show();
            }
            else {
                $(this).remove();
            }
        });

        //UpdateImageMapDimensions(panel);
    }

    //Reset colorpicker values
    //SetColorPickers($(".colorPicker", panel));
}

questionnaireEditor.resetLogicStartValues = function (panel) {
    $(".v-conditionControl .customValueSequence, .v-conditionControl input:visible, .v-conditionControl input[type='hidden'], .v-conditionControl select:visible", panel).each(function () {
        if (questionnaireEditor.editValues[$(this).attr("id")] !== undefined) {
            $(this).val(questionnaireEditor.editValues[$(this).attr("id")]);

            if ($(this).hasClass("autocomplete")) {

                //$(this).attr("value", "");
                //$(this).attr("value", $(this).val().value);
                //questionnaireEditor.getQuestionByName($(".h-startquestion-autocomplete", _row).val()).value;
                $(this).autocomplete('option', 'select').call($(this));

                $(this).removeAttr("data-value");
            }

            if ($(this).is("select")) {
                $(this).trigger("change");
            }
        }
    });
}

questionnaireEditor.setSettings = function (panel, settings) {
    panel.find(".v-setting").each(function () {
        var value;
        var setSetting = true;

        if ($(this).is(":checkbox")) {
            value = $(this).is(":checked");
        }
        else if ($(this).is(":radio")) {
            if ($(this).is(':checked')) {
                value = $(this).val();
            } else {
                setSetting = false;
            }
        }
        else if ($(this).hasClass("v-selectMultipleVariables")) {
            value = _.pluck($(this).a4autocomplete("getValue"), "name").join(',');
        }
        else if ($(this).hasClass("v-EliminationExcludedFields") || $(this).hasClass("v-RowEliminationExcludedFields")) {
            // Choices and Row/statement elimination for variable Numeric code 
            value = _.pluck($(this).a4autocomplete("getValue"), "Code").join(',');
        }
        else if ($(this).hasClass("v-ColumnEliminationExcluded") || $(this).hasClass("v-RowEliminationExcluded")) {
            value = _.pluck($(this).a4autocomplete("getValue"), "Position").join(',');
        }
        else if ($(this).hasClass("v-softPromptChoice") && $(this).hasClass("autocomplete")) {
            value = $(this).a4autocomplete("getValue");
            if (value && value.Code) value = value.Code;
        }
        else if ($(this).hasClass("v-qeRichEditText")) {
            value = a4.getInputValue($(this));
        }
        else {
            value = $(this).val();
        }

        if (setSetting) {
            settings[$(this).attr("data-name")] = value;
        }
    });
}

questionnaireEditor.setTranslatableSettings = function (panel, translatableSettings) {
    panel.find(".v-translatableSetting").each(function () {
        var value;

        if ($(this).hasClass("rich-text-editor"))
            value = $(this).a4richTextEditor("getContent");
        else
            value = $(this).val();

        translatableSettings[$(this).attr("data-name")] = value;
    });
}

questionnaireEditor.unsavedChange = function () {
    var unsavedChange = false;
    var item = null;
    var value = null;
    var inEditPanel = $(".inEdit, .inEditTitle", questionnaireEditor.container);

    for (var valKey in questionnaireEditor.editValues) {
        if (!unsavedChange && valKey) {
            item = $("#" + valKey, inEditPanel).length > 0 ? $("#" + valKey, inEditPanel) : $("[data-name='" + valKey + "']", inEditPanel);
            unsavedChange = (questionnaireEditor.editValues[valKey] != questionnaireEditor.getItemValue(item));
        }
    }

    // Look for added or deleted choice list rows
    if (!unsavedChange) {
        unsavedChange = ($(".v-choiceListBody #ChoiceRow0:not(.deleted)", inEditPanel).length != 0
                          || $(".v-choiceListBody .v-questionEditableItem.deleted", inEditPanel).not("[id$='Row0']").length != 0
                          || $(".v-choiceListBody .v-questionEditableItem.moved", inEditPanel).length != 0);
    }

    if (!unsavedChange) {
        for (var choiceKey in questionnaireEditor.editChoices) {
            if (!unsavedChange && choiceKey) {
                item = $("#" + choiceKey, inEditPanel);
                unsavedChange = (questionnaireEditor.editChoices[choiceKey] != questionnaireEditor.getItemValue(item));
            }
        }
    }

    if (!unsavedChange) {
        var logicPanel = null;

        if ($(".editBlockContent:visible", questionnaireEditor.container).length > 0) {
            logicPanel = $(".editBlockContent:visible", inEditPanel);
        }
        else if ($(".questionLogicPanel:visible", inEditPanel).length > 0) {
            logicPanel = $(".questionLogicPanel:visible", inEditPanel);
        }

        unsavedChange = (logicPanel && $(".skipLogicEditor.updated", logicPanel).length != 0);

        if (!unsavedChange && logicPanel) {
            $(".v-itemsContainer .v-questionEditableItem", logicPanel).each(function () {
                var item = $(this);
                var id = item.attr("id");

                if (!unsavedChange && item && id) {
                    unsavedChange = (item.hasClass("moved") || item.hasClass("updated") || item.hasClass("deleted")
                                  || (!item.hasClass("saved") && (id == "LogicRow0" || id == "ActionRow0" || id == "RandomizationRow0")));
                }
            });
        }
    }

    return unsavedChange;
}

questionnaireEditor.showUnsavedChangesConfirmation = function (yesFn, noFn, resourceText) {
    questionnaireEditor.showUnsavedConfirmation(yesFn, noFn, questionnaireEditor.resources.UnsavedChangesQuestionnaire, true);
}

questionnaireEditor.unsavedChangesForLogic = function () {
    var inEditPanel = $(".inEdit", questionnaireEditor.container);

    // Question name change
    var qName = $(".v-questionName", inEditPanel);
    var unsavedChange = questionnaireEditor.editValues[qName.attr("id")] != qName.val();

    // If a grid question - check for variable changes
    if (!unsavedChange && questionnaireEditor.currentEditor != null && questionnaireEditor.editValues["RowsData"] != null) {
        var initRows = JSON.parse(questionnaireEditor.editValues["RowsData"]);
        var currentRows = _.reject(JSON.parse($("#RowsData", inEditPanel).val()), function (r) { return !r; });

        unsavedChange = _.flatten(_.map(_.compact(_.pluck(initRows, "VariableNames")), _.values)).join("@")
            != _.flatten(_.map(_.compact(_.pluck(currentRows, "VariableNames")), _.values)).join("@");        
    }

    // If a grid question - check for changed choice codes or text
    if (!unsavedChange && questionnaireEditor.currentEditor != null && questionnaireEditor.editValues["ColumnsData"] != null) {
        var initChoices = _.pluck(JSON.parse(questionnaireEditor.editValues["ColumnsData"]), "Choices");
        var currentChoices = _.pluck(JSON.parse($("#ColumnsData", inEditPanel).val()), "Choices");

        unsavedChange = _.pluck(_.compact(_.flatten(initChoices)), "Code").join("@")
                            != _.pluck(_.compact(_.flatten(currentChoices)), "Code").join("@");

        if (!unsavedChange) {
            unsavedChange = _.pluck(_.compact(_.flatten(initChoices)), "Text").join("@")
                                != _.pluck(_.compact(_.flatten(currentChoices)), "Text").join("@");
        }
    }

    // Look for added or deleted choice list rows
    if (!unsavedChange) {
        unsavedChange = ($(".v-choiceListBody #ChoiceRow0:not(.deleted)", inEditPanel).length != 0
                    || $(".v-choiceListBody .v-questionEditableItem.deleted", inEditPanel).not("[id$='Row0']").length != 0);
    }

    if (!unsavedChange) {
        unsavedChange = $(".v-choiceListEditor .v-questionEditableItem:data('choices')", inEditPanel).length != 0;
    }

    if (!unsavedChange) {
        _.each(_.filter(_.keys(questionnaireEditor.editChoices), function (c) { return c.indexOf("choiceCode") == 0; }), function (item, index) {
            if (!unsavedChange && item) {
                unsavedChange = (questionnaireEditor.editChoices[item] != questionnaireEditor.getItemValue($("#" + item, inEditPanel)));
            }
        });
    }

    if (!unsavedChange) {
        _.each(_.filter(_.keys(questionnaireEditor.editChoices), function (c) { return c.indexOf("choiceText") == 0; }), function (item, index) {
            if (!unsavedChange && item) {
                unsavedChange = (questionnaireEditor.editChoices[item] != questionnaireEditor.getItemValue($("#" + item, inEditPanel)));
            }
        });
    }

    // Look at added variable rows
    if (!unsavedChange) {
        unsavedChange = ($(".v-cardListTable #VariableRow0:not(.deleted)", inEditPanel).length != 0
            || $(".v-cardListTable .v-questionEditableItem.deleted[id!=VariableRow0]", inEditPanel).length != 0
            || $(".v-areaEditor #VariableRow0:not(.deleted)", inEditPanel).length != 0
            || $(".v-areaEditor .v-questionEditableItem.deleted[id!=VariableRow0]", inEditPanel).length != 0
            || $(".v-dropdownsContainer #DropdownRow0:not(.deleted)", inEditPanel).length != 0
            || $(".v-dropdownsContainer .v-questionEditableItem.deleted[id!=DropdownRow0]", inEditPanel).length != 0
            || $(".v-lookupTableEditorContainer #ColumnRow0:not(.deleted)", inEditPanel).length != 0
            || $(".v-lookupTableEditorContainer .v-questionEditableItem.deleted[id!=ColumnRow0]", inEditPanel).length != 0
            || $(".v-highlightCategoryListTable #VariableRow0:not(.deleted)", inEditPanel).length != 0
            || $(".v-highlightCategoryListTable .v-questionEditableItem.deleted[id!=VariableRow0]", inEditPanel).length != 0);
        
    }

    var initVarType = questionnaireEditor.editValues["VarType"];

    if (!unsavedChange && initVarType != undefined) {
        unsavedChange = initVarType != $(".v-varType:checked", inEditPanel).val();
    }

    return unsavedChange;
}

questionnaireEditor.showUnsavedChangesForLogicConfirmation = function (yesFn, noFn, resourceText) {
    questionnaireEditor.showUnsavedConfirmation(yesFn, noFn, questionnaireEditor.resources.UnsavedChangesForLogic, false);
}

questionnaireEditor.showUnsavedConfirmation = function (yesFn, noFn, resourceText, showClose) {
    var content = $('<div>').append($('<div class="unsavedMessage">' + resourceText + '</div>'));

    var unsavedResources = {
        "Title": questionnaireEditor.resources.PendingChanges,
        "Message": content,
        "SaveButtonText": sharedResources["Yes"],
        "CancelButtonText": sharedResources["No"]
    };

    modalDialog.showRequiredActionDialog(unsavedResources, yesFn, noFn, 220, 500, showClose);
}

// --------------- GENERAL FUNCTIONS ------------------------------------

questionnaireEditor.verifyIfQuestionIsInViewport = function (questionBlock) {
    //will return true if any part of the question container is visible in the viewport

    var top = questionBlock.offsetTop;
    var left = questionBlock.offsetLeft;
    var width = questionBlock.offsetWidth;
    var height = questionBlock.offsetHeight;

    while (questionBlock.offsetParent) {
        questionBlock = questionBlock.offsetParent;
        top += questionBlock.offsetTop;
        left += questionBlock.offsetLeft;
    }

    return (
        top < (window.pageYOffset + window.innerHeight) &&
        left < (window.pageXOffset + window.innerWidth) &&
        (top + height) > window.pageYOffset &&
        (left + width) > window.pageXOffset
    );
}

questionnaireEditor.questionIsMultiVariable = function (questionId) {
    var question = questionnaireEditor.getQuestionById(questionId);
    var questionType = question.type;

    var multiVariableTypes = $.grep(questionnaireEditor.questionTypes, function (e, i) {
        return (e.name == "ChoiceGrid"
            || e.name == "HybridGrid"
            || e.name == "RunningTotal"
            || e.name == "ImageChoiceGrid"
            || e.name == "StarRatingGrid"
            || (e.name == "NetPromoter" && !questionnaireEditor.useS2)
            || e.name == "CardSort"
            || e.name == "DrillDown"
            || e.name == "ImageAreaEvaluator"
            || e.name == "LookupTable"
            || e.name == "TextHighlighter"
            || e.name == "Carrousel");
    });

    var found = $.grep(multiVariableTypes, function (e) {
        if (questionType == e.value) return true;
    });

    return (found.length > 0);
}

questionnaireEditor.disableInvalidCharacters = function (e) {
    var key = e.which;

    return (
            (key > 47 && key < 58) || // 0 - 9
            (key > 64 && key < 91) || // A - Z
            (key > 96 && key < 129) || // a - z
             key == 95 || // _             
             key == 8 || //Backspace
             key == 45 || // -
             key == 46 || // .
             key == 0);
}

questionnaireEditor.getInEditQuestion = function () {
    return $(".v-blockItemPanel.inEdit", questionnaireEditor.container);
}

questionnaireEditor.getInEditQuestionTitle = function () {
    return $(".v-questionTitleGroup.inEditTitle", questionnaireEditor.container);
}

questionnaireEditor.saveConfiguration = function () {
    var changeMade = ((questionnaireEditor.activeBlock != null && questionnaireEditor.activeBlock != questionnaireEditor.configuration["BlockId"])
                        || (questionnaireEditor.lastOpenQuestion != null && questionnaireEditor.lastOpenQuestion != questionnaireEditor.configuration["BlockItemId"]));

    if (questionnaireEditor.activeBlock != null)
        questionnaireEditor.configuration["BlockId"] = questionnaireEditor.activeBlock;

    if (questionnaireEditor.lastOpenQuestion != null)
        questionnaireEditor.configuration["BlockItemId"] = questionnaireEditor.lastOpenQuestion;

    if (changeMade) {
        var args = { id: questionnaireEditor.configuration.Id, settings: questionnaireEditor.serializeConfiguration(questionnaireEditor.configuration) };
        a4.callServerMethod(questionnaireEditor.getUrl("UpdateUserPageConfiguration"), args, function () { }, function () { });
    }
}

questionnaireEditor.serializeConfiguration = function (config) {
    var data = null;

    if (config) {
        var clone = $.extend({}, config);
        delete clone["Id"];
        data = JSON.stringify(clone);
    }

    return data;
}

questionnaireEditor.updateConfiguration = function (blockId, question) {
    if (question !== null) {
        questionnaireEditor.lastOpenQuestion = questionnaireEditor.blockController.getBlockItemIdFromElement(question);
        questionnaireEditor.activeBlock = questionnaireEditor.blockController.getBlockIdFromElement(question.closest(".v-blockPanel"));
    }
    else {
        questionnaireEditor.activeBlock = blockId;
    }

    questionnaireEditor.saveConfiguration();
}


questionnaireEditor.addConflictsToContent = function (content, errors, height) {
    var ul = $("ul", content);

    if (errors.length == 0) {
        $(".v-conflictItems", content).remove();
    }
    else {
        // Add conflicts
        $.each(errors, function (i, val) {
            ul.append("<li>" + val.substring(val.indexOf("br/>") + 4) + "</li>");
            height += 40;
        });
    }

    return height;
}

questionnaireEditor.isReadonly = function () {
    return $('.questionnaireIsReadOnly').val() == "1";
}

// -------------------  Dialogs -------------------------------

questionnaireEditor.showLocationDialog = function (title, isCopy, block, question, callback) {
    var moveContainer = $("#moveToPanel", questionnaireEditor.container).clone();
    var container = $('<div id="MoveQuestionToPanel">').append(moveContainer.html().replace(/moveBeforeLocation/g, "moveBeforeLocationEdit").replace(/moveAfterLocation/g, "moveAfterLocationEdit"));

    var initContentFunction = function () {
        var editor = $("#MoveQuestionToPanel");
        $(".v-copyContainer", editor).toggle(isCopy);

        if (isCopy) {
            $(".v-copyOrMove").text(questionnaireEditor.resources.CopyToBlock);
            $(".v-placeCopyOrMove").text(questionnaireEditor.resources.PlaceCopy);
        }
        else {
            $(".v-copyOrMove").text(questionnaireEditor.resources.MoveToBlock);
            $(".v-placeCopyOrMove").text(questionnaireEditor.resources.Move);
        }

        $(".v-numberofTimes", editor).autoNumeric({ aPad: false, vMax: questionnaireEditor.maxQuestionsCopy, mDec: '0', aSep: '', vMin: '1' });

        editor.one("click", ".v-numberofTimes", function () {
            $(this).val("");
        });

        $(".v-moveToBlock", editor).a4autocomplete({
            data: questionnaireEditor.getSortedBlocks(),
            valueProperty: "value",
            labelProperty: "name",
            placeHolder: questionnaireEditor.resources.SelectBlock,
            select: function (event, ui) {
                $(".v-moveToContainer,.v-moveLocationContainer", editor).toggle(ui.item != undefined);

                if (ui.item) {
                    var questions = questionnaireEditor.getQuestionsByBlockId(ui.item.value);
                    var hasQuestions = (questions.length > 0);
                    $(".v-moveToContainer,.v-moveLocationContainer", editor).toggle(hasQuestions);

                    $(".v-moveToQuestion", editor).a4autocomplete({
                        data: questions,
                        placeHolder: questionnaireEditor.resources.SelectQuestion,
                        valueProperty: "value",
                        labelProperty: "name"
                    });
                }
            }
        });

        if (block != null) {
            $(".v-moveToBlock", editor).prop("value", block.name);
            $(".v-moveToBlock", editor).attr("data-value", block.blockId);

            if (question != null) {
                $(".v-moveToContainer,.v-moveLocationContainer", editor).toggle(true);

                $(".v-moveToQuestion", editor).prop("value", question.name);
                $(".v-moveToQuestion", editor).attr("data-value", question.questionId);
            }

            var questions = questionnaireEditor.getQuestionsByBlockId(block.blockId);
            $(".v-moveToContainer,.v-moveLocationContainer", editor).toggle(questions.length > 0);

            $(".v-moveToQuestion", editor).a4autocomplete({
                data: questions,
                placeHolder: questionnaireEditor.resources.SelectQuestion,
                valueProperty: "value",
                labelProperty: "name"
            });
        }
    }

    var validateContentFunction = function () {
        var editor = $("#MoveQuestionToPanel");
        var valid = true;

        if ($(".v-moveToBlock", editor).val() == "") {
            a4.showErrorMessage(questionnaireEditor.resources.BlockNameRequired);
            valid = false;
        }
        else if ($(".v-moveToContainer", editor).is(":visible") && $(".v-moveToQuestion", editor).val() == "") {
            a4.showErrorMessage(questionnaireEditor.resources.QuestionNameIsRequired);
            valid = false;
        }
        else if ($.inArray($(".v-numberofTimes", editor).val(), ["", "0"]) > -1) {
            a4.showErrorMessage(questionnaireEditor.resources.CopyNumberRequired);
            valid = false;
        }

        return valid;
    }

    var moveResources = {
        "Title": title,
        "Message": container
    };

    modalDialog.showConfirmDialog(moveResources,
        function () {
            var editor = $("#MoveQuestionToPanel");
            var block = $(".v-moveToBlock", editor).attr("data-value");
            var location = $(".v-moveToLocation:checked", editor).val();
            var question = $(".v-moveToQuestion", container).is(":visible") ? $(".v-moveToQuestion", container).attr("data-value") : null;
            var nbTimes = parseInt($(".v-numberofTimes", container).val(), 10);

            callback(block, location, question, nbTimes);
        }, 350, 500, false, null, { initFunction: initContentFunction, validateFunction: validateContentFunction });
}

questionnaireEditor.showSplitBlockDialog = function (callback) {
    var defaultBlockName = "block_" + (questionnaireEditor.nbBlocks++);

    $("#splitBlockPanel", questionnaireEditor.container).find("input[type=text]").attr("value", defaultBlockName);
    var splitContainer = $("#splitBlockPanel", questionnaireEditor.container).clone();
    var container = $('<div id="SplitBlockPanel">').append(splitContainer.html());

    var validateContentFunction = function () {
        var editor = $("#SplitBlockPanel");
        var valid = true;

        if ($(".v-newBlockName", editor).val() == "") {
            a4.showErrorMessage(questionnaireEditor.resources.BlockNameRequired);
            valid = false;
        }

        return valid;
    }

    var moveResources = {
        "Title": questionnaireEditor.resources.SplitBlockTitle,
        "Message": container
    };

    modalDialog.showConfirmDialog(moveResources,
        function () {
            var editor = $("#SplitBlockPanel");
            var block = $(".v-newBlockName", editor).val();
            callback(block);
        }
        , 300, 550, false, null,
        { validateFunction: validateContentFunction });
}

questionnaireEditor.showAddToLibraryDialog = function (questionName, confirmFunction) {
    var libraryContainer = $("#addToLibraryContainer", questionnaireEditor.container);
    var showInputName = (questionName != null);
    $(".v-libraryQuestionName", libraryContainer).toggle(showInputName);


    var content = libraryContainer.html().replace("{0}", showInputName ? questionName : "");
    var container = $('<div id="AddToLibraryPanel">').append($('<div>' + content + '</div>'));
    var name = "";
    var categoryId = 0;

    var popupResources = {
        "Title": questionnaireEditor.resources.AddToLibrary,
        "Message": container
    };

    var initContentFunction = function () {
        var editor = $("#AddToLibraryPanel");
        var categories = $(".v-questionCategory", editor);

        _.each(questionnaireEditor.questionCategories, function (c) {
            categories
             .append($("<option></option>")
             .attr("value", c.Id)
             .text(c.Name));
        });
    };

    var validateContentFunction = function () {
        var editor = $("#AddToLibraryPanel");
        questionnaireEditor.errorOnRequest = false;

        if (showInputName) {
            name = $(".v-libraryName", editor).val();
            questionnaireEditor.validateName(name, questionnaireEditor.resources.NameRequired);
        }

        categoryId = $("select.v-questionCategory option:selected", editor).val();
        questionnaireEditor.validateCategory(categoryId, questionnaireEditor.resources.CategoryRequired);

        return !questionnaireEditor.errorOnRequest;
    }

    modalDialog.showConfirmDialog(popupResources,
        function () {
            confirmFunction(name, categoryId);
        }
        , 300, 500, false, null, { initFunction: initContentFunction, validateFunction: validateContentFunction });
}

// ----------------- Highlight Copied Question ----------------------------

questionnaireEditor.highlightCopied = function (foundItem, block) {
    if (foundItem && block) {
        var questionContainer = $(".v-questionsContainer", block);

        if (questionContainer.is(":hidden") || questionContainer.length == 0) {
            questionnaireEditor.questionnaireMode.toggleBlock($(".v-blockOptions .v-expandButton", block), true, function () { questionnaireEditor.highlightCopiedQuestion(foundItem, block) });
        }
        else {
            questionnaireEditor.highlightCopiedQuestion(foundItem, block);
        }
    }
}

questionnaireEditor.highlightCopiedQuestion = function (foundItem, block) {
    var blockItem = questionnaireEditor.questionnaireMode.getBlockItemElementInBlockWithId(block, foundItem);
    setTimeout(function () {
        $('html, body').animate({
            scrollTop: $(".h-questionTitle", blockItem).offset().top - 200
        }, 500);
    }, 20);
}

// ----------------- Find Questions ----------------------------

questionnaireEditor.highlightFindCurrent = function () {
    if (questionnaireEditor.findPosition != null) {
        var foundItem = questionnaireEditor.findQuestions[questionnaireEditor.findPosition];
        var block = questionnaireEditor.questionnaireMode.getBlockElementFromId(foundItem.blockId);
        var questionContainer = $(".v-questionsContainer", block);

        if (questionContainer.is(":hidden") || questionContainer.length == 0) {
            questionnaireEditor.questionnaireMode.toggleBlock($(".v-blockOptions .v-expandButton", block), true, function () { questionnaireEditor.highlightFindCurrentQuestion(foundItem, block) });
        }
        else {
            questionnaireEditor.highlightFindCurrentQuestion(foundItem, block);
        }
    }
}

questionnaireEditor.highlightFindCurrentQuestion = function (foundItem, block) {

    var blockItem = questionnaireEditor.questionnaireMode.getBlockItemElementInBlockWithId(block, foundItem.value);
    var questionContent = blockItem.find(".v-editQuestionContent");

    if (questionContent.is(":hidden")) {
        questionnaireEditor.toggleQuestion($(".v-expandButton", blockItem), false);
    }

    $(".v-questionDisplay", questionnaireEditor.container).removeClass("questionNameItemHighlighted");
    $(".v-questionStructureDisplay", questionnaireStructure.container).removeClass("questionNameItemHighlighted");

    if (!questionnaireEditor.isStructureViewMode) {
        $(".v-questionDisplay", blockItem).addClass("questionNameItemHighlighted");
    } else {
        $(".v-questionStructureDisplay", blockItem).addClass("questionNameItemHighlighted");
    }

    $(".findQuestionPanel .foundQuestions", questionnaireEditor.container).text((questionnaireEditor.findPosition + 1) + " / " + questionnaireEditor.findQuestions.length);

    //setTimeout(function () { $(window).scrollTo($(".h-questionTitle", blockItem), 500, { axis: 'y', offset: { top: -20 } }); }, 20);
    setTimeout(function () {
        $('html, body').animate({
            scrollTop: $(".h-questionTitle", blockItem).offset().top - 80
        }, 500);
    }, 20);
}

questionnaireEditor.clearHighlightedQuestions = function () {
    $(".v-questionDisplay", questionnaireEditor.container).removeClass("questionNameItemHighlighted");
}

questionnaireEditor.hideFindQuestionPanel = function () {
    $(".v-advancedSearch .v-resultTable").hide();
    questionnaireEditor.clearHighlightedQuestions();
}

questionnaireEditor.setAdvancedFindEvents = function () {
    var resultTable = $(".v-resultTable", questionnaireEditor.container);

    resultTable.mCustomScrollbar({ theme: "dark-2", scrollInertia: 0 });

    $(".h-advancedSearchBtn", questionnaireEditor.container).on("click", function (e) {
        questionnaireEditor.executeAdvancedSearch($(this).closest(".v-advancedSearch"));
    });

    questionnaireEditor.container.on("click", ".v-advancedSearchResult", function () {
        $(".v-advancedSearchResult.selected", questionnaireEditor.container).removeClass("selected");
        $(this).addClass("selected");
        questionnaireEditor.findQuestions[0] = questionnaireEditor.getQuestionById($(this).attr("data-id"));
        questionnaireEditor.findPosition = 0;
        questionnaireEditor.highlightFindCurrent();
    });

    questionnaireEditor.container.on("keypress", ".v-advancedSearchInput", function (event) {
        if (event.keyCode == 13) {
            questionnaireEditor.executeAdvancedSearch($(this).closest(".v-advancedSearch"));
        }

        return event.keyCode != 13;
    });

    questionnaireEditor.container.on("focusin", ".v-advancedSearchInput", function (event) {
        $(this).addClass("active");
        if ($(this).val() == $(this).attr("data-searchtext")) {
            $(this).val("");
        }

    });

    questionnaireEditor.container.on("focusout", ".v-advancedSearchInput", function (event) {
        $(this).removeClass("active");
        if ($(this).val() == "") {
            $(this).val($(this).attr("data-searchtext"));
        }
    });
}

questionnaireEditor.executeAdvancedSearch = function (searchPanel) {
    var resultTable = $(".v-resultTable", questionnaireEditor.container);
    var searchTextBox = $(".v-advancedSearchInput", searchPanel);
    var searchCriteria;
    var tableBody = $(".v-results", searchPanel);

    if (searchTextBox.val() == searchTextBox.attr("data-searchtext")) {
        searchCriteria = "";
    }
    else {
        searchCriteria = searchTextBox.val();
    }

    var options = $(".v-options input:checked", searchPanel).map(
    function () {
        return $.map($(this).val().split(","), function (key, value) { return parseInt(key) });
    }).toArray();

    if (searchCriteria.length > 0 && options.length > 0) {

        $("v-resultTable", searchPanel).hide();
        $(".v-searchLoadingDiv", searchPanel).show();

        a4.callServerMethod(questionnaireEditor.getUrl("ExecuteAdvancedSearch"), { criteria: searchCriteria, options: options, indexCheck: questionnaireEditor.requireIndexVerification },
			function (result) {
			    $(".v-searchLoadingDiv", searchPanel).hide();
			    $(".v-resultTable", searchPanel).show();
			    tableBody.html("");
			    $.map(result, function (result) {
			        var toolTip = result.ObjectType + " - " + result.QuestionName + " - " + result.Value;
			        tableBody.append("<tr class=\"v-advancedSearchResult\" data-id=\"" + result.QuestionId + "\" title=\"" + toolTip + "\"><td class=\"questionNameCell\">" + result.QuestionName + "</td><td class=\"objectTypeCell\">" + result.ObjectType + "</td><td class=\"textCell\">" + result.Value + "</td></tr>");
			        questionnaireEditor.calculateAdvancedSearchResultScroll(resultTable);
			    });
			},
			function (error) {
			    tableBody.html("");
			    questionnaireEditor.calculateAdvancedSearchResultScroll(resultTable);
			    a4.onAjaxPageMethodError(error);
			}
		);

        questionnaireEditor.requireIndexVerification = false;
    } else {
        tableBody.html("");
        questionnaireEditor.calculateAdvancedSearchResultScroll(resultTable);
    }
}

questionnaireEditor.calculateAdvancedSearchResultScroll = function (resultTable) {
    var contentHeight = $(".overview", resultTable).height();
    var viewportHeight = $(window).outerHeight();
    var leftPanelElementsHeight = $(".v-leftPanel .h-headerItem").outerHeight();
    var searchPanelHeight = $(".v-advancedSearch .v-search").outerHeight();
    var safePaddingHeight = 25;

    var folders = $(".v-leftPanel .v-libraryBrowser > .v-folderParent .v-sectionHeader");
    folders.each(function () {
        leftPanelElementsHeight += $(this).outerHeight();
    });

    var maxHeight = viewportHeight - (leftPanelElementsHeight + searchPanelHeight + safePaddingHeight + 206);

    if (contentHeight < maxHeight) {
        resultTable.height(contentHeight);
    } else {
        resultTable.height(maxHeight);
    }

    resultTable.mCustomScrollbar({ theme: "dark-2", scrollInertia: 0 });
}

questionnaireEditor.hybridGridHasMultipleColumns = function (questionId) {
    var questionContainer = $("#blockItemPanel" + questionId);
    var gridTable = questionContainer.find(".hybridGrid");

    if (gridTable.length != 0) {
        var variableRows = gridTable.find("tbody tr[id]");

        if (variableRows.length > 0) {
            var columns = $(variableRows[0]).find("td:not(.gridRowHeader)");

            return (columns.length > 1 && questionnaireEditor.GridColumnsHaveDifferentPositions(columns));
        }
    }

    return false;
}

questionnaireEditor.GridColumnsHaveDifferentPositions = function (columns) {
    var position = $(columns[0]).attr("data-column-position");

    for (var i = 1; i < columns.length; i++) {
        var currentPosition = $(columns[i]).attr("data-column-position");

        if (currentPosition != position)
            return true;

        position = currentPosition;
    }

    return false;
}

// --------------- Questionnaire functions on settings -------------------------

questionnaireEditor.getBlockByName = function (blockName) {
    return _.find(questionnaireEditor.blocks, function (block) { return block.name.toUpperCase() == blockName.toUpperCase(); });
}

questionnaireEditor.getBlockById = function (blockId) {
    return _.find(questionnaireEditor.blocks, function (block) { return block.value == blockId; });
}

questionnaireEditor.getSortedBlocks = function () {
    return questionnaireEditor.blocks.sort(questionnaireEditor.sortBlocks)
}

questionnaireEditor.sortBlocks = function (a, b) {
    return (a.blockPosition > b.blockPosition) ? 1 : -1;
};

questionnaireEditor.getQuestionByName = function (questionName) {
    return _.find(questionnaireEditor.questions, function (question) { return question.name.toUpperCase() == questionName.toUpperCase(); });
}

questionnaireEditor.getPatternIdByName = function (patternName) {
    var n = questionnaireEditor.resources.RandomizationPatterns.length;
    for (var i = 0; i < n; i += 1) {
        if (questionnaireEditor.resources.RandomizationPatterns[i]["Label"] === patternName) {
            var value = questionnaireEditor.resources.RandomizationPatterns[i]["Value"];
            return value;
        }
    }
}

questionnaireEditor.getPanelByName = function (panelName) {
    return _.find(questionnaireEditor.panels, function (panel) { return panel.name.toUpperCase() == panelName.toUpperCase(); });
}

questionnaireEditor.getPanelById = function (Id) {
    return _.find(questionnaireEditor.panels, function (panel) { return panel.value == Id; });
}

questionnaireEditor.getQuestionsByFind = function (findText) {
    var regExp = new RegExp("(" + findText + ")", "i");
    return _.filter(questionnaireEditor.questions, function (question) { return regExp.test(question.name); }).sort(questionnaireEditor.sortQuestions);
}

questionnaireEditor.sortQuestions = function (a, b) {
    return (a.blockPosition > b.blockPosition || (a.blockPosition == b.blockPosition && a.position > b.position)) ? 1 : -1;
};

questionnaireEditor.getSortedQuestions = function () {
    return questionnaireEditor.questions.sort(questionnaireEditor.sortQuestions)
}

questionnaireEditor.getQuestionById = function (questionId) {
    return _.find(questionnaireEditor.questions, function (question) { return question.value == questionId });
}

questionnaireEditor.getQuestionsByBlockId = function (blockId) {
    return _.filter(questionnaireEditor.questions, function (question) { return question.blockId == blockId }).sort(questionnaireEditor.sortQuestions);
}

questionnaireEditor.getQuestionsExceptSelf = function (questionId) {
    return _.filter(questionnaireEditor.questions, function (question) { return question.value != questionId; }).sort(questionnaireEditor.sortQuestions);
}

questionnaireEditor.getQuestionsType = function (questionType) {
    return _.find(questionnaireEditor.questionTypes, function (type) { return type.name == questionType; });
}

questionnaireEditor.getQuestionsTypeById = function (id) {
    return _.find(questionnaireEditor.questionTypes, function (type) { return type.value == id; });
}

questionnaireEditor.getQuestionVariables = function (questionId) {
    return _.filter(questionnaireEditor.variables, function (variable) { return variable.questionId == questionId; }).sort(questionnaireEditor.sortVariables);
}

questionnaireEditor.getVariableByName = function (variableName) {
    return _.find(questionnaireEditor.variables, function (variable) { return variable.name.toUpperCase() == variableName.toUpperCase(); });
}

questionnaireEditor.getVariableById = function (variableId) {
    return _.find(questionnaireEditor.variables, function (variable) { return variable.value == variableId; });
}

questionnaireEditor.getVariablesByQuestionId = function (questionId) {
    return _.filter(questionnaireEditor.variables, function (variable) { return variable.questionId == questionId; });
}

questionnaireEditor.getVariableNames = function () {
    return _.pluck(questionnaireEditor.variables.sort(questionnaireEditor.sortVariables), "name");
}

questionnaireEditor.getVariableLabelsExceptQuestion = function (questionId) {
    return _.filter(questionnaireEditor.variables, function (variable) { return variable.questionId != questionId; }).sort(questionnaireEditor.sortVariables);
}

questionnaireEditor.sortVariables = function (a, b) {
    question_a = questionnaireEditor.getQuestionById(a.questionId);
    question_b = questionnaireEditor.getQuestionById(b.questionId);

    if (question_a.blockPosition < question_b.blockPosition) {
        return -1;
    } else if (question_a.blockPosition > question_b.blockPosition) {
        return 1;
    } else {
        if (question_a.position < question_b.position) {
            return -1;
        } else if (question_a.position > question_b.position) {
            return 1;
        } else {
            if (a.name < b.name) {
                return -1;
            } else if (a.name > b.name) {
                return 1;
            } else {
                return 0;
            }
        }
    }
};

questionnaireEditor.getSortedVariables = function () {
    return questionnaireEditor.variables.sort(questionnaireEditor.sortVariables);
}

questionnaireEditor.getVariableNamesExcludingQuestion = function (questionId) {
    return _.pluck(_.filter(questionnaireEditor.variables, function (variable) { return variable.questionId != questionId; }).sort(questionnaireEditor.sortVariables), "name");
}

questionnaireEditor.getVariableNamesFromQuestion = function (questionId) {
    return _.pluck(_.filter(questionnaireEditor.variables, function (variable) { return variable.questionId == questionId; }).sort(questionnaireEditor.sortVariables), "name");
}

questionnaireEditor.getVariableWithSameChoiceList = function (questionId, choiceListId) {
    var variable = _.find(questionnaireEditor.variables, function (variable) { return variable.questionId != questionId && variable.choiceListId == choiceListId; });
    var variableName;
    if (variable)
        variableName = variable.name;

    return variableName;
}

questionnaireEditor.getQuestionsWithSameChoiceList = function (questionId, choiceListId) {
    return _.filter(questionnaireEditor.questions, function (question) { return question.value != questionId && question.choiceListId == choiceListId });
}

questionnaireEditor.getChoiceLabelsByVariable = function (variableName) {
    return _.pluck(_.filter(questionnaireEditor.choices, function (choice) { return choice.variableName == variableName; }), "name"); //.sort(top.SortAlphanumericString);
}

questionnaireEditor.getChoicesByVariable = function (variableName) {
    return _.filter(questionnaireEditor.choices, function (choice) { return choice.variableName == variableName; }); //.sort(top.SortAlphanumericString);
}

questionnaireEditor.getChoiceByLabel = function (variableName, choiceLabel) {
    return _.find(questionnaireEditor.choices, function (choice) { return choice.variableName == variableName && choice.name == choiceLabel; });
}

questionnaireEditor.getActionsByQuestionId = function (questionId) {
    return _.filter(questionnaireEditor.actions, function (action) { return action.questionId == questionId }).sort(questionnaireEditor.sortActions);
}

questionnaireEditor.sortActions = function (a, b) {
    return (a.type >= b.type && a.position > b.position) ? 1 : -1;
}

questionnaireEditor.getActionsByQuestionIdAndAction = function (questionId, action) {
    return _.sortBy(_.filter(questionnaireEditor.actions, function (action) { return action.questionId == questionId && action.value == action }), 'type');
}

questionnaireEditor.sortBlocks = function (a, b) {
    return (a.position > b.position) ? 1 : -1;
};

questionnaireEditor.getQuestionnaireBlocks = function () {
    return questionnaireEditor.blocks.sort(questionnaireEditor.sortBlocks);
}


function GetQuestionnaireQuestions() {
    return questionnaireEditor.questions.sort(questionnaireEditor.sortQuestions);
}

function GetQuestionnaireVariables() {
    return questionnaireEditor.variables.sort(questionnaireEditor.sortVariables);
}

function FindQuestions(findText) {
    var regexp = new RegExp(findText, "i");
    return _.filter(questionnaireEditor.questions, function (question) { return regexp.test(question.name); });
}

questionnaireEditor.getPanels = function () {
    return questionnaireEditor.panels;
}

questionnaireEditor.getPanelAttributes = function (panelId) {
    return _.filter(questionnaireEditor.panelAttributes, function (attribute) { return attribute.panelId == 0 || attribute.panelId == panelId; });
}

questionnaireEditor.getPanelAttributeByName = function (attributeName) {
    return _.find(questionnaireEditor.panelAttributes, function (attribute) { return attribute.name.toUpperCase() == attributeName.toUpperCase(); });
}

questionnaireEditor.getPanelRequiredAttributes = function (panelId, requiredFields) {
    return _.filter(questionnaireEditor.panelAttributes, function (attribute) {
        return ((attribute.panelId == 0 && questionnaireEditor.isPanelistFieldRequired(attribute, requiredFields))
            || (attribute.panelId == panelId && attribute.isRequired));
    });
}

questionnaireEditor.isPanelistFieldRequired = function (field, requiredFields) {
    var req = false;

    switch (field.name) {
        case "FirstName": req = (requiredFields & 1) == 1; break;
        case "LastName": req = (requiredFields & 2) == 2; break;
        case "Email": req = (requiredFields & 4) == 4; break;
        case "UserName": req = (requiredFields & 8) == 8; break;
        case "Password": req = (requiredFields & 16) == 16; break;
        case "Gender": req = (requiredFields & 32) == 32; break;
        case "DateOfBirth": req = (requiredFields & 64) == 64; break;
        case "TimeZone": req = (requiredFields & 128) == 128; break;
        case "Language": req = (requiredFields & 256) == 256; break;
    }

    return req;
}

// ---------------------------- Validation ----------------------------

questionnaireEditor.validateName = function (name, emptyNameMessage) {
    if (name == "") {
        a4.showErrorMessage(emptyNameMessage);
        questionnaireEditor.errorOnRequest = true;
    }
    else if (!questionnaireEditor.validName(name)) {
        a4.showErrorMessage(questionnaireEditor.resources.NameInvalidSyntax);
        questionnaireEditor.errorOnRequest = true;
    }
}

questionnaireEditor.validName = function (questionName) {
    var namePattern = /^[A-Za-z0-9 _]*$/;
    return namePattern.test(questionName);
}

questionnaireEditor.validateCategory = function (categoryId, categoryIsRequiredMessage) {
    if (isNaN(categoryId)) {
        a4.showErrorMessage(categoryIsRequiredMessage);
        questionnaireEditor.errorOnRequest = true;
    }
}

questionnaireEditor.validateSettings = function (container, questionType, settings, choices) {
    if (questionType == DATE_TIME_ANSWER && !questionnaireEditor.errorOnRequest) {
        var dateValidator = new dateTimeAnswerValidator();
        dateValidator.init( settings["MinValue"],
                        settings["MaxValue"],
                        settings["Type"],
                        settings["DateFormat"],
                        settings["TimeFormat"]);

        if (!dateValidator.isValid()) {
            questionnaireEditor.errorOnRequest = true;
            a4.showErrorMessage(dateValidator.errorMessage());
        }

        questionnaireEditor.validateDisabledDateControl();
    }
    else {
        questionnaireEditor.validateMinMax(settings["MinValue"], settings["MaxValue"]);
    }

    if (!questionnaireEditor.errorOnRequest) {
        questionnaireEditor.validateMinRequiredMaxAllowed(settings["MinRequiredAnswers"], settings["MaxAllowedAnswers"]);
    }

    if (questionType == SLIDER && !questionnaireEditor.errorOnRequest) {
        questionnaireEditor.validateSliderSettings(container, settings, choices);
    }
    else if (questionType == NET_PROMOTER_GRID && !questionnaireEditor.errorOnRequest) {
        questionnaireEditor.validateNetPromoterSettings(container, settings, choices);
    }
    else if (questionnaireEditor.isGridQuestionType(questionType)) {
        questionnaireEditor.errorOnRequest |= !$(".gridEditor", container).gridEditor("validate");
    }

    return !questionnaireEditor.errorOnRequest;
}

questionnaireEditor.validateSliderSettings = function (container, settings, choices) {
    if (settings["DisplayNoAnswer"] && !settings["NoAnswerValue"]) {
        questionnaireEditor.errorOnRequest = true;
        a4.showErrorMessage(questionnaireEditor.resources.NoAnswerValueRequired);
        $(".v-setting[data-name='NoAnswerValue']", container).trigger("focus");
        return false;
    }

    if (settings["VarType"] != "0") { // We test undefined, we dont validate discrete slider
        return questionnaireEditor.validateSliderMinMaxFields(settings["MinValue"], settings["MaxValue"], settings["DefaultValue"]);
    } else if (choices && choices.length == 0) {
        questionnaireEditor.errorOnRequest = true;
        a4.showErrorMessage(questionnaireEditor.resources.ChoiceIsRequired);
        return false;
    }

    return true;
}

questionnaireEditor.validateNetPromoterSettings = function (container, settings, choices) {
    if (parseInt(settings["Promoters"]) < parseInt(settings["Detractors"])) {
        questionnaireEditor.errorOnRequest = true;
        a4.showErrorMessage(questionnaireEditor.resources.ErrorDetractorsLowerThanPromoters);
        $(".v-setting[data-name='Promoters']", container).trigger("focus");
        return false;
    }

    return true;
}

questionnaireEditor.validateDisabledDateControl = function () {
    if ($(".h-disableDateControlRoot").is(":visible") && questionnaireEditor.disabledDateControl.isValid() == false) {
        a4.showErrorMessage(questionnaireEditor.resources.ErrorDisableDateInvalid);
        questionnaireEditor.errorOnRequest = true;
        return false;
    }

    return true;
}

questionnaireEditor.validateMinMax = function (minValue, maxValue) {
    if (minValue && minValue != "" && minValue.indexOf("[") == -1 && maxValue && maxValue != "" && maxValue.indexOf("[") == -1 && minValue != "TodayValue" && maxValue != "TodayValue") {
        if (!isNaN(minValue) && !isNaN(maxValue)) {
            questionnaireEditor.errorOnRequest = parseFloat(minValue) > parseFloat(maxValue);
        }
        else {
            questionnaireEditor.errorOnRequest = minValue > maxValue;
        }

        if (questionnaireEditor.errorOnRequest) {
            a4.showErrorMessage(questionnaireEditor.resources.MaxValueLowerThanMinValue);
            return false;
        }
    }

    return true;
}

questionnaireEditor.validateMinMaxDates = function (minValue, maxValue, dateFormat) {
    if (minValue && minValue != "" && minValue != "TodayValue" && maxValue && maxValue != "" && maxValue != "TodayValue") {
        var formatLength = dateFormat.length;
        dateFormat = dateFormat.replace(/yy/g, "y").toLowerCase();

        try {
            // For use variable then no need to validate
            var minDate = (minValue.indexOf("[") != -1) ? null : $.datepicker.parseDate(dateFormat, minValue.substring(0, formatLength).trim()); //Removing time from datetime
            var maxDate = (maxValue.indexOf("[") != -1) ? null : $.datepicker.parseDate(dateFormat, maxValue.substring(0, formatLength).trim()); //Removing time from datetime

            questionnaireEditor.errorOnRequest = (minDate != null && maxDate != null && new Date(minDate) > new Date(maxDate));
        }
        catch (error) {
            questionnaireEditor.errorOnRequest = true;
        }

        if (questionnaireEditor.errorOnRequest) {
            a4.showErrorMessage(questionnaireEditor.resources.MaxValueLowerThanMinValue);
            return false;
        }
    }

    return true;
}

questionnaireEditor.validateSliderMinMaxFields = function (minValue, maxValue, defaultValue) {
    if (!minValue || minValue == "") {
        a4.showErrorMessage(questionnaireEditor.resources.MinValueRequired);
        questionnaireEditor.errorOnRequest = true;
        return false;
    }
    else if (!maxValue || maxValue == "") {
        a4.showErrorMessage(questionnaireEditor.resources.MaxValueRequired);
        questionnaireEditor.errorOnRequest = true;
        return false;
    }
    else if (defaultValue && (parseFloat(defaultValue) < parseFloat(minValue) || parseFloat(maxValue) < parseFloat(defaultValue))) {
        a4.showErrorMessage(questionnaireEditor.resources.InvalidDefaultValue);
        questionnaireEditor.errorOnRequest = true;
        return false;
    }

    return true;
}

questionnaireEditor.validateMinRequiredMaxAllowed = function (minRequired, maxAllowed) {
    if (parseInt(minRequired) > parseInt(maxAllowed)) {
        a4.showErrorMessage(questionnaireEditor.resources.MaxRequiredAnswersLowerThanMin);
        questionnaireEditor.errorOnRequest = true;
        return false;
    }

    return true;
}

questionnaireEditor.validateCardsMinRequiredMaxAllowed = function (minRequired, maxAllowed, cardsCount) {
    if (parseInt(minRequired) > cardsCount) {
        a4.showErrorMessage(questionnaireEditor.resources.MinRequiredAnswersHigherThanCards);
        questionnaireEditor.errorOnRequest = true;
        return false
    }
    else if (parseInt(maxAllowed) > cardsCount) {
        a4.showErrorMessage(questionnaireEditor.resources.MaxAllowedAnswersHigherThanCards);
        questionnaireEditor.errorOnRequest = true;
        return false
    }

    return true;
}

questionnaireEditor.getUrl = function (action, params) {
    if (!params)
        params = {};

    params.surveyId = questionnaireEditor.Id;

    return a4.getSurveyAction(action, "Questionnaire", params);
}

questionnaireEditor.initializeNumericInputs = function (context) {
    questionnaireEditor.initializeNumericInput($(".v-validateInt", context), -999999999, 999999999, 0);
    questionnaireEditor.initializeNumericInput($(".v-validateLong", context), -999999999999999999, 999999999999999999, 0);
    questionnaireEditor.initializeNumericInput($(".v-validatePositiveInt", context), 0, 999999999, 0);
    questionnaireEditor.initializeNumericInput($(".v-validateFloat", context), -999999999, 999999999, 2);
    questionnaireEditor.initializeNumericInput($(".v-validatePositiveFloat", context), 0, 999999999, 2);
}

questionnaireEditor.initializeNumericAnswerInputs = function (context) {
    var decimals = parseInt($(".v-numberOfDecimals", context).val());

    if (isNaN(decimals)) {
        decimals = 0;
    }

    questionnaireEditor.initializeNumericInput($(".v-numericAnswerMinMaxValue", context), -999999999999999999, 999999999999999999, decimals);
}

questionnaireEditor.initializeNumericInput = function (selector, minValue, maxValue, decimals) {
    selector.each(function () {
        var inputMinValue = decimals > 0 ? parseFloat($(this).attr("data-min-value"), 10) : parseInt($(this).attr("data-min-value"), 10);
        var inputMaxValue = decimals > 0 ? parseFloat($(this).attr("data-max-value"), 10) : parseInt($(this).attr("data-max-value"), 10);

        if (!isNaN(inputMinValue))
            minValue = inputMinValue;

        if (!isNaN(inputMaxValue))
            maxValue = inputMaxValue;

        $(this).autoNumeric({ vMin: minValue, vMax: maxValue, mDec: decimals, aDec: "." });
    });
}
$(document).on("change", "#heatMapOutlineColor", function () {
    colorChanged('#heatMapOutlineColor');
});
$(document).on("click", "#oulineSizeOptions li", function (ev) {
    var value = +$(this).attr('value');
    var className="";
    switch (value) {
        case 1:
            className = 'one';
            break;
        case 2:
            className = 'two';
            break;
        case 3:
            className = 'three';
            break;
        case 4:
            className = 'four';
            break;
        default:
            className = 'five';
            break;
    }
    $('.v-outlineWeightText').attr('value', value);
    $('#heatMapOutlineWeight').val(value);
    var item = "<span  value=" +value+ "><hr class='" + className + "' />" + value + "</span>";
    $('.v-outlineWeightBtn').html(item);
    $(".heatmapOutlineSizeToggle").toggle(false);
});
$(document).on("click", ".v-outlineWeightBtn", function (ev) {
    $(".heatmapOutlineSizeToggle").toggle(true);
});

$(document).on('click', function (e) {
    if ($(e.target).closest("#buttonToggleHeatMap").length === 0) {
        $(".heatmapOutlineSizeToggle").toggle(false);
    }
});

function colorChanged(id) {
    $(id + "Text").val($(id).val());
}
